/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.command.test;

import com.github.stephengold.joltjni.RVec3;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.command.test.IVxTestCommand;
import net.xmx.velthoric.physics.ragdoll.VxRagdollManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class SpawnRagdollTest
implements IVxTestCommand {
    @Override
    public String getName() {
        return "spawnRagdoll";
    }

    @Override
    public void registerArguments(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"position", (ArgumentType)Vec3Argument.m_120841_()).executes(this::execute)));
    }

    private int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = EntityArgument.m_91452_(context, (String)"entity");
        Vec3 spawnPos = Vec3Argument.m_120844_(context, (String)"position");
        if (!(entity instanceof LivingEntity)) {
            source.m_81352_((Component)Component.m_237113_((String)"The target must be a living entity (e.g., a player, zombie, etc.)."));
            return 0;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        VxPhysicsWorld world = VxPhysicsWorld.get((ResourceKey<Level>)livingEntity.m_9236_().m_46472_());
        if (world == null) {
            source.m_81352_((Component)Component.m_237113_((String)"The physics world is not running in this dimension."));
            return 0;
        }
        VxRagdollManager ragdollManager = world.getRagdollManager();
        if (ragdollManager != null) {
            RVec3 joltSpawnPos = new RVec3((float)spawnPos.f_82479_, (float)spawnPos.f_82480_, (float)spawnPos.f_82481_);
            ragdollManager.createHumanoidRagdoll(livingEntity, joltSpawnPos);
            source.m_288197_(() -> Component.m_237113_((String)("Spawning a ragdoll for " + livingEntity.m_7755_().getString())), true);
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)"Could not access the ragdoll manager."));
        return 0;
    }
}

