/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.datafixer;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.xmx.velthoric.datafixer.VxDataVersionRegistry;
import net.xmx.velthoric.datafixer.VxIBufFixer;
import net.xmx.velthoric.network.VxByteBuf;

public class VxBufFixerManager {
    private final ImmutableMap<Integer, VxIBufFixer> fixers;

    public VxBufFixerManager(List<VxIBufFixer> fixerList) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (VxIBufFixer fixer : fixerList) {
            builder.put((Object)fixer.getFromVersion(), (Object)fixer);
        }
        this.fixers = builder.build();
    }

    public VxByteBuf process(int savedSchemaVersion, VxByteBuf data) {
        int targetSchemaVersion = VxDataVersionRegistry.getCurrentSchemaVersion();
        if (savedSchemaVersion > targetSchemaVersion) {
            data.release();
            throw new IllegalArgumentException("Cannot process data from a future version. Saved: " + savedSchemaVersion + ", Current: " + targetSchemaVersion);
        }
        if (savedSchemaVersion == targetSchemaVersion) {
            return data;
        }
        VxByteBuf currentData = data;
        for (int version = savedSchemaVersion; version < targetSchemaVersion; ++version) {
            VxIBufFixer fixer = (VxIBufFixer)this.fixers.get((Object)version);
            if (fixer == null) {
                currentData.release();
                throw new IllegalStateException("Missing data fixer to upgrade from schema version " + version + " to " + (version + 1));
            }
            ByteBuf nextRawData = Unpooled.buffer((int)(currentData.readableBytes() + 32));
            VxByteBuf nextData = new VxByteBuf(nextRawData);
            fixer.apply(currentData, nextData);
            currentData.release();
            currentData = nextData;
        }
        return currentData;
    }
}

