/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.datafixer;

import com.google.common.annotations.VisibleForTesting;
import dev.architectury.platform.Platform;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class VxDataVersionRegistry {
    private static final Map<String, Integer> versionToSchemaMap = new ConcurrentHashMap<String, Integer>();
    private static final AtomicInteger currentSchemaVersion = new AtomicInteger(-1);

    private VxDataVersionRegistry() {
    }

    public static void register(String modVersion, int schemaVersion) {
        if (versionToSchemaMap.putIfAbsent(modVersion, schemaVersion) != null) {
            System.err.println("Schema for mod version " + modVersion + " was already registered.");
        }
    }

    public static void initialize() {
        Platform.getOptionalMod((String)"velthoric").ifPresent(mod -> {
            String version = mod.getVersion();
            Integer schema = versionToSchemaMap.get(version);
            if (schema == null) {
                throw new IllegalStateException("No data schema version registered for current mod version: " + version);
            }
            currentSchemaVersion.set(schema);
        });
    }

    public static int getCurrentSchemaVersion() {
        int version = currentSchemaVersion.get();
        if (version == -1) {
            throw new IllegalStateException("VxDataVersionRegistry has not been initialized.");
        }
        return version;
    }

    @VisibleForTesting
    public static void reset() {
        versionToSchemaMap.clear();
        currentSchemaVersion.set(-1);
    }
}

