/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.body;

import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.body.manager.VxNetworkDispatcher;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkMap.class})
public abstract class MixinChunkMap_ChunkTracking {
    @Shadow
    @Final
    ServerLevel f_140133_;

    @Unique
    private VxNetworkDispatcher velthoric$getDispatcher() {
        VxBodyManager manager;
        VxPhysicsWorld world = VxPhysicsWorld.get((ResourceKey<Level>)this.f_140133_.m_46472_());
        if (world != null && (manager = world.getBodyManager()) != null) {
            return manager.getNetworkDispatcher();
        }
        return null;
    }

    @Inject(method={"updateChunkTracking"}, at={@At(value="HEAD")})
    private void velthoric$onUpdateChunkTracking(ServerPlayer player, ChunkPos chunkPos, MutableObject<ClientboundLevelChunkWithLightPacket> packetCache, boolean wasVisible, boolean isVisible, CallbackInfo ci) {
        if (isVisible == wasVisible) {
            return;
        }
        VxNetworkDispatcher dispatcher = this.velthoric$getDispatcher();
        if (dispatcher == null) {
            return;
        }
        if (!isVisible) {
            dispatcher.untrackBodiesInChunkForPlayer(player, chunkPos);
        }
    }

    @Inject(method={"playerLoadedChunk"}, at={@At(value="TAIL")})
    private void velthoric$onPlayerLoadedChunk(ServerPlayer serverPlayer, MutableObject<ClientboundLevelChunkWithLightPacket> mutableObject, LevelChunk levelChunk, CallbackInfo ci) {
        VxNetworkDispatcher dispatcher = this.velthoric$getDispatcher();
        if (dispatcher != null) {
            dispatcher.trackBodiesInChunkForPlayer(serverPlayer, levelChunk.m_7697_());
        }
    }

    @Inject(method={"updatePlayerStatus"}, at={@At(value="TAIL")})
    private void velthoric$onPlayerLeave(ServerPlayer player, boolean track, CallbackInfo ci) {
        VxNetworkDispatcher dispatcher;
        if (!track && (dispatcher = this.velthoric$getDispatcher()) != null) {
            dispatcher.onPlayerDisconnect(player);
        }
    }
}

