/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.mounting.render;

import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.math.VxConversions;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.mounting.entity.VxMountingEntity;
import net.xmx.velthoric.physics.mounting.util.VxMountingRenderUtils;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Camera.class})
public abstract class MixinCamera {
    @Shadow
    @Final
    private Quaternionf f_90559_;
    @Shadow
    @Final
    private Vector3f f_90554_;
    @Shadow
    @Final
    private Vector3f f_90555_;
    @Shadow
    @Final
    private Vector3f f_90556_;
    @Shadow
    private boolean f_90549_;
    @Shadow
    private BlockGetter f_90550_;
    @Shadow
    private boolean f_90560_;
    @Shadow
    private Entity f_90551_;
    @Shadow
    private float f_90562_;
    @Shadow
    private float f_90563_;
    @Shadow
    private float f_90558_;
    @Shadow
    private float f_90557_;
    @Shadow
    private Vec3 f_90552_;
    @Unique
    private final VxTransform velthoric_interpolatedTransform = new VxTransform();

    @Shadow
    protected abstract void m_90584_(double var1, double var3, double var5);

    @Shadow
    protected abstract void m_90568_(double var1, double var3, double var5);

    @Shadow
    protected abstract double m_90566_(double var1);

    @Inject(method={"setup"}, at={@At(value="HEAD")}, cancellable=true)
    private void velthoric_followPhysicsBody(BlockGetter area, Entity focusedEntity, boolean thirdPerson, boolean inverseView, float partialTick, CallbackInfo ci) {
        VxMountingEntity proxy;
        Optional<VxTransform> transformOpt;
        Entity entity = focusedEntity.m_20202_();
        if (entity instanceof VxMountingEntity && (transformOpt = VxMountingRenderUtils.INSTANCE.getInterpolatedTransform(proxy = (VxMountingEntity)entity, partialTick, this.velthoric_interpolatedTransform)).isPresent()) {
            VxTransform transform = transformOpt.get();
            Quaternionf physRotation = transform.getRotation(new Quaternionf());
            Vector3f rideOffset = new Vector3f((Vector3fc)proxy.getMountPositionOffset());
            physRotation.transform(rideOffset);
            Vector3d playerBasePos = VxConversions.toJoml(transform.getTranslation(), new Vector3d()).add((double)rideOffset.x, (double)rideOffset.y, (double)rideOffset.z);
            double eyeY = Mth.m_14179_((float)partialTick, (float)this.f_90563_, (float)this.f_90562_);
            Vector3f eyeOffset = new Vector3f(0.0f, (float)eyeY, 0.0f);
            physRotation.transform(eyeOffset);
            Vector3d playerEyePos = playerBasePos.add((double)eyeOffset.x(), (double)eyeOffset.y(), (double)eyeOffset.z());
            this.f_90549_ = true;
            this.f_90550_ = area;
            this.f_90551_ = focusedEntity;
            this.f_90560_ = thirdPerson;
            float currentYaw = focusedEntity.m_5675_(partialTick);
            float currentPitch = focusedEntity.m_5686_(partialTick);
            this.velthoric_setRotationWithPhysicsTransform(currentYaw, currentPitch, physRotation);
            this.m_90584_(playerEyePos.x, playerEyePos.y, playerEyePos.z);
            if (thirdPerson) {
                if (inverseView) {
                    this.velthoric_setRotationWithPhysicsTransform(currentYaw + 180.0f, -currentPitch, physRotation);
                }
                this.m_90568_(-this.velthoric_getMaxZoomIgnoringPhysicsBody(4.0), 0.0, 0.0);
            }
            ci.cancel();
        }
    }

    @Unique
    private void velthoric_setRotationWithPhysicsTransform(float yaw, float pitch, Quaternionf physRotation) {
        Quaterniond originalRotation = new Quaterniond().rotateY(Math.toRadians(-yaw)).rotateX(Math.toRadians(pitch));
        Quaterniond newRotation = new Quaterniond((Quaternionfc)physRotation).mul((Quaterniondc)originalRotation).normalize();
        this.f_90557_ = pitch;
        this.f_90558_ = yaw;
        this.f_90559_.set((Quaterniondc)newRotation);
        this.f_90554_.set(0.0f, 0.0f, 1.0f).rotate((Quaternionfc)this.f_90559_);
        this.f_90555_.set(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)this.f_90559_);
        this.f_90556_.set(1.0f, 0.0f, 0.0f).rotate((Quaternionfc)this.f_90559_);
    }

    @Unique
    private double velthoric_getMaxZoomIgnoringPhysicsBody(double maxZoom) {
        for (int i = 0; i < 8; ++i) {
            double dist;
            Vec3 end;
            float f = (float)((i & 1) * 2 - 1) * 0.1f;
            float g = (float)((i >> 1 & 1) * 2 - 1) * 0.1f;
            float h = (float)((i >> 2 & 1) * 2 - 1) * 0.1f;
            Vec3 start = this.f_90552_.m_82520_((double)f, (double)g, (double)h);
            BlockHitResult hitResult = this.f_90550_.m_45547_(new ClipContext(start, end = new Vec3(this.f_90552_.f_82479_ - (double)this.f_90554_.x() * maxZoom + (double)f + (double)h, this.f_90552_.f_82480_ - (double)this.f_90554_.y() * maxZoom + (double)g, this.f_90552_.f_82481_ - (double)this.f_90554_.z() * maxZoom + (double)h), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, this.f_90551_));
            if (hitResult.m_6662_() == HitResult.Type.MISS || !((dist = hitResult.m_82450_().m_82554_(this.f_90552_)) < maxZoom)) continue;
            maxZoom = dist;
        }
        return maxZoom;
    }
}

