/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.mounting.render;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.math.VxConversions;
import net.xmx.velthoric.math.VxOBB;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.mounting.entity.VxMountingEntity;
import net.xmx.velthoric.physics.mounting.entity.VxMountingEntityState;
import net.xmx.velthoric.physics.mounting.util.VxMountingRenderUtils;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class MixinGameRenderer {
    @Shadow
    @Final
    Minecraft f_109059_;
    @Shadow
    @Final
    private Camera f_109054_;
    @Unique
    private final Map<Integer, VxMountingEntityState> velthoric_originalStates = new HashMap<Integer, VxMountingEntityState>();
    @Unique
    private final VxTransform velthoric_interpolatedTransform = new VxTransform();

    @Shadow
    protected abstract double m_109141_(Camera var1, float var2, boolean var3);

    @Shadow
    public abstract Matrix4f m_253088_(double var1);

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V", shift=At.Shift.BEFORE)})
    private void velthoric_preRenderLevel(float tickDelta, long startTime, boolean tick, CallbackInfo ci) {
        ClientLevel clientWorld = this.f_109059_.f_91073_;
        if (clientWorld == null) {
            return;
        }
        this.velthoric_originalStates.clear();
        for (Entity entity : clientWorld.m_104735_()) {
            Entity passenger;
            VxMountingEntity proxy;
            if (!(entity instanceof VxMountingEntity) || (proxy = (VxMountingEntity)entity).m_20197_().isEmpty() || (passenger = proxy.m_146895_()) == null) continue;
            this.velthoric_adjustEntityForRender(proxy, tickDelta);
            this.velthoric_adjustEntityForRender(passenger, tickDelta);
        }
    }

    @Unique
    private void velthoric_adjustEntityForRender(Entity entity, float tickDelta) {
        VxMountingEntity proxy;
        Entity entity2 = entity.m_20202_();
        if (entity2 instanceof VxMountingEntity) {
            VxMountingEntity vehicleProxy;
            proxy = vehicleProxy = (VxMountingEntity)entity2;
        } else if (entity instanceof VxMountingEntity) {
            VxMountingEntity selfProxy;
            proxy = selfProxy = (VxMountingEntity)entity;
        } else {
            return;
        }
        VxMountingRenderUtils.INSTANCE.getInterpolatedTransform(proxy, tickDelta, this.velthoric_interpolatedTransform).ifPresent(transform -> {
            this.velthoric_originalStates.computeIfAbsent(entity.m_19879_(), k -> new VxMountingEntityState()).setFrom(entity);
            Quaternionf physRotation = transform.getRotation(new Quaternionf());
            Vector3f rideOffset = new Vector3f((Vector3fc)proxy.getMountPositionOffset());
            physRotation.transform(rideOffset);
            double targetX = transform.getTranslation().xx() + (double)rideOffset.x();
            double targetY = transform.getTranslation().yy() + (double)rideOffset.y();
            double targetZ = transform.getTranslation().zz() + (double)rideOffset.z();
            entity.m_6034_(targetX, targetY, targetZ);
            entity.f_19854_ = targetX;
            entity.f_19855_ = targetY;
            entity.f_19856_ = targetZ;
            entity.f_19790_ = targetX;
            entity.f_19791_ = targetY;
            entity.f_19792_ = targetZ;
        });
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void velthoric_postRenderLevel(float tickDelta, long startTime, boolean tick, CallbackInfo ci) {
        ClientLevel clientWorld = this.f_109059_.f_91073_;
        if (clientWorld == null) {
            return;
        }
        this.velthoric_originalStates.forEach((id, state) -> {
            Entity entity = clientWorld.m_6815_(id.intValue());
            if (entity != null) {
                state.applyTo(entity);
            }
        });
        this.velthoric_originalStates.clear();
    }

    @WrapOperation(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;prepareCullFrustum(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/world/phys/Vec3;Lorg/joml/Matrix4f;)V")})
    private void velthoric_setupCameraWithPhysicsBody(LevelRenderer instance, PoseStack poseStack, Vec3 cameraPos, Matrix4f projectionMatrix, Operation<Void> original) {
        LocalPlayer player = this.f_109059_.f_91074_;
        if (player != null) {
            float partialTicks = this.f_109059_.m_91296_();
            VxMountingRenderUtils.INSTANCE.ifMountedOnBody((Entity)player, partialTicks, physQuat -> {
                Quaternionf physRotation = VxConversions.toJoml(physQuat, new Quaternionf());
                poseStack.m_252781_(physRotation.conjugate());
                double fov = this.m_109141_(this.f_109054_, partialTicks, true);
                Matrix4f newProjectionMatrix = this.m_253088_(Math.max(fov, (double)((Integer)this.f_109059_.f_91066_.m_231837_().m_231551_()).intValue()));
                original.call(new Object[]{instance, poseStack, this.f_109054_.m_90583_(), newProjectionMatrix});
            });
        }
        original.call(new Object[]{instance, poseStack, cameraPos, projectionMatrix});
    }

    @WrapOperation(method={"pick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/ProjectileUtil;getEntityHitResult(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;D)Lnet/minecraft/world/phys/EntityHitResult;")})
    private EntityHitResult velthoric_pickEntityWithOBB(Entity shooter, Vec3 start, Vec3 end, AABB searchBox, Predicate<Entity> filter, double maxDistanceSq, Operation<EntityHitResult> original) {
        Predicate<Entity> vanillaFilter = filter.and(entity -> !(entity.m_20202_() instanceof VxMountingEntity));
        EntityHitResult vanillaResult = (EntityHitResult)original.call(new Object[]{shooter, start, end, searchBox, vanillaFilter, maxDistanceSq});
        double closestHitDistSq = vanillaResult != null ? start.m_82557_(vanillaResult.m_82450_()) : maxDistanceSq;
        EntityHitResult bestOverallResult = vanillaResult;
        List potentialTargets = this.f_109059_.f_91073_.m_6249_(shooter, searchBox, filter);
        for (Entity target : potentialTargets) {
            double distSq;
            Optional<EntityHitResult> obbHit;
            if (!(target.m_20202_() instanceof VxMountingEntity) || !(obbHit = this.velthoric_performObbRaycast(target, start, end)).isPresent() || !((distSq = start.m_82557_(obbHit.get().m_82450_())) < closestHitDistSq)) continue;
            closestHitDistSq = distSq;
            bestOverallResult = obbHit.get();
        }
        return bestOverallResult;
    }

    @Unique
    private Optional<EntityHitResult> velthoric_performObbRaycast(Entity target, Vec3 start, Vec3 end) {
        Entity entity = target.m_20202_();
        if (!(entity instanceof VxMountingEntity)) {
            return Optional.empty();
        }
        VxMountingEntity proxy = (VxMountingEntity)entity;
        return this.velthoric_createTargetOBB(target, proxy).flatMap(obb -> obb.clip(start, end)).map(hitPos -> new EntityHitResult(target, hitPos));
    }

    @Unique
    private Optional<VxOBB> velthoric_createTargetOBB(Entity target, VxMountingEntity proxy) {
        float partialTicks = this.f_109059_.m_91296_();
        return VxMountingRenderUtils.INSTANCE.getInterpolatedTransform(proxy, partialTicks, this.velthoric_interpolatedTransform).map(transform -> {
            Vector3f rideOffset = new Vector3f((Vector3fc)proxy.getMountPositionOffset());
            transform.getRotation(new Quaternionf()).transform(rideOffset);
            transform.getTranslation().addInPlace(rideOffset.x(), rideOffset.y(), rideOffset.z());
            AABB targetAABB = target.m_20191_().m_82400_((double)target.m_6143_());
            AABB localEntityAABB = targetAABB.m_82386_(-target.m_20185_(), -target.m_20186_(), -target.m_20189_());
            return new VxOBB((VxTransform)transform, localEntityAABB);
        });
    }
}

