/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.persistence;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityStorage.class})
public abstract class MixinEntityStorage_PersistBodiesAndConstraints
implements EntityPersistentStorage<Entity> {
    @Shadow
    @Final
    private ServerLevel f_156538_;
    @Shadow
    @Final
    private ProcessorMailbox<Runnable> f_182485_;

    @Inject(method={"storeEntities"}, at={@At(value="HEAD")})
    private void onStoreEntities(ChunkEntities<Entity> entities, CallbackInfo ci) {
        VxPhysicsWorld world = VxPhysicsWorld.get((ResourceKey<Level>)this.f_156538_.m_46472_());
        if (world != null) {
            world.getBodyManager().saveBodiesInChunk(entities.m_156791_());
            world.getConstraintManager().saveConstraintsInChunk(entities.m_156791_());
        }
    }

    @Inject(method={"loadEntities"}, at={@At(value="RETURN")}, cancellable=true)
    private void onLoadEntities(ChunkPos pos, CallbackInfoReturnable<CompletableFuture<ChunkEntities<Entity>>> cir) {
        CompletableFuture originalFuture = (CompletableFuture)cir.getReturnValue();
        CompletionStage newFuture = originalFuture.thenApplyAsync(chunkEntities -> {
            VxPhysicsWorld world = VxPhysicsWorld.get((ResourceKey<Level>)this.f_156538_.m_46472_());
            if (world != null) {
                world.getBodyManager().getBodyStorage().loadBodiesInChunk(pos);
                world.getConstraintManager().getConstraintStorage().loadConstraintsInChunk(pos);
            }
            return chunkEntities;
        }, arg_0 -> this.f_182485_.m_6937_(arg_0));
        cir.setReturnValue((Object)newFuture);
    }
}

