/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.natives;

import com.github.stephengold.joltjni.BroadPhaseLayerInterface;
import com.github.stephengold.joltjni.Jolt;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.ObjectLayerPairFilter;
import com.github.stephengold.joltjni.ObjectVsBroadPhaseLayerFilter;
import java.nio.file.Path;
import net.xmx.velthoric.natives.VxNativeManager;
import net.xmx.velthoric.physics.world.VxLayers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VxNativeJolt {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Velthoric JoltJNI");
    private static volatile boolean isInitialized = false;

    public static void initialize(Path extractionPath) {
        if (isInitialized) {
            return;
        }
        LOGGER.debug("Performing JoltJNI initialization...");
        VxNativeManager.loadLibrary(extractionPath, "joltjni");
        Jolt.registerDefaultAllocator();
        Jolt.installDefaultAssertCallback();
        Jolt.installDefaultTraceCallback();
        JoltPhysicsObject.startCleaner();
        if (!Jolt.newFactory()) {
            throw new IllegalStateException("Jolt Factory could not be created.");
        }
        Jolt.registerTypes();
        VxLayers.initialize();
        isInitialized = true;
        LOGGER.debug("JoltJNI native library loaded and initialized successfully via Velthoric loader.");
    }

    public static void shutdown() {
        if (!isInitialized) {
            return;
        }
        LOGGER.debug("Performing JoltJNI shutdown...");
        VxLayers.shutdown();
        Jolt.destroyFactory();
        isInitialized = false;
        LOGGER.debug("JoltJNI shutdown complete.");
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static BroadPhaseLayerInterface getBroadPhaseLayerInterface() {
        return VxLayers.getBroadPhaseLayerInterface();
    }

    public static ObjectVsBroadPhaseLayerFilter getObjectVsBroadPhaseLayerFilter() {
        return VxLayers.getObjectVsBroadPhaseLayerFilter();
    }

    public static ObjectLayerPairFilter getObjectLayerPairFilter() {
        return VxLayers.getObjectLayerPairFilter();
    }
}

