/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.natives;

import dev.architectury.platform.Platform;
import java.nio.file.Path;
import net.xmx.velthoric.Arch;
import net.xmx.velthoric.OS;
import net.xmx.velthoric.UnsupportedOperatingSystemException;
import net.xmx.velthoric.VxNativeLibraryLoader;
import net.xmx.velthoric.natives.VxNativeJolt;
import net.xmx.velthoric.natives.VxNativeZstd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VxNativeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Velthoric Native Manager");
    private static volatile boolean areNativesInitialized = false;

    public static synchronized void initialize() {
        if (areNativesInitialized) {
            return;
        }
        LOGGER.info("Initializing Velthoric native libraries...");
        Path extractionPath = Platform.getGameFolder().resolve("velthoric").resolve("natives");
        try {
            VxNativeZstd.initialize(extractionPath);
            VxNativeJolt.initialize(extractionPath);
            areNativesInitialized = true;
            LOGGER.info("All Velthoric native libraries initialized successfully.");
        }
        catch (Exception e) {
            LOGGER.error("A critical error occurred while loading native libraries. Velthoric may not function correctly.", (Throwable)e);
            throw new RuntimeException("Failed to initialize Velthoric natives", e);
        }
    }

    static void loadLibrary(Path extractionPath, String libraryName) {
        OS os = OS.detect();
        Arch arch = Arch.detect();
        if (os == null || arch == null) {
            throw new UnsupportedOperatingSystemException("Unsupported platform: " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ")");
        }
        String libFileName = System.mapLibraryName(libraryName);
        String resourcePath = String.format("/natives/%s/%s/%s", os.folder, arch.folder, libFileName);
        LOGGER.debug("Attempting to load '{}' from resource path '{}'", (Object)libFileName, (Object)resourcePath);
        VxNativeLibraryLoader.load(extractionPath, resourcePath, libFileName);
    }

    public static boolean areNativesInitialized() {
        return areNativesInitialized;
    }
}

