/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import dev.architectury.utils.GameInstance;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.xmx.velthoric.item.boxthrower.packet.VxBoxThrowerActionPacket;
import net.xmx.velthoric.item.chaincreator.packet.VxChainCreatorActionPacket;
import net.xmx.velthoric.item.magnetizer.packet.VxMagnetizerActionPacket;
import net.xmx.velthoric.item.physicsgun.packet.VxPhysicsGunActionPacket;
import net.xmx.velthoric.item.physicsgun.packet.VxPhysicsGunSyncPacket;
import net.xmx.velthoric.physics.body.packet.batch.S2CRemoveBodyBatchPacket;
import net.xmx.velthoric.physics.body.packet.batch.S2CSpawnBodyBatchPacket;
import net.xmx.velthoric.physics.body.packet.batch.S2CSynchronizedDataBatchPacket;
import net.xmx.velthoric.physics.body.packet.batch.S2CUpdateBodyStateBatchPacket;
import net.xmx.velthoric.physics.body.packet.batch.S2CUpdateVerticesBatchPacket;
import net.xmx.velthoric.physics.mounting.input.C2SMountInputPacket;
import net.xmx.velthoric.physics.mounting.request.C2SRequestMountPacket;
import net.xmx.velthoric.physics.vehicle.sync.S2CVehicleStatePacket;

public class VxPacketHandler {
    private static final String CHANNEL_NAMESPACE = "velthoric";
    private static final Map<Class<?>, PacketInfo<?>> PACKETS = new HashMap();

    private static <T> void registerPacket(Class<T> type, String name, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkManager.PacketContext>> handler) {
        ResourceLocation packetId = new ResourceLocation(CHANNEL_NAMESPACE, name);
        PACKETS.put(type, new PacketInfo<T>(packetId, encoder));
        NetworkManager.NetworkReceiver receiver = (buf, context) -> {
            Object packet = decoder.apply(buf);
            handler.accept(packet, () -> context);
        };
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)packetId, (NetworkManager.NetworkReceiver)receiver);
        if (Platform.getEnvironment() == Env.CLIENT) {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)packetId, (NetworkManager.NetworkReceiver)receiver);
        }
    }

    public static void register() {
        VxPacketHandler.registerPacket(VxChainCreatorActionPacket.class, "chain_creator_action", VxChainCreatorActionPacket::encode, VxChainCreatorActionPacket::decode, VxChainCreatorActionPacket::handle);
        VxPacketHandler.registerPacket(C2SRequestMountPacket.class, "request_mount", C2SRequestMountPacket::encode, C2SRequestMountPacket::decode, C2SRequestMountPacket::handle);
        VxPacketHandler.registerPacket(S2CSynchronizedDataBatchPacket.class, "sync_data_batch", S2CSynchronizedDataBatchPacket::encode, S2CSynchronizedDataBatchPacket::decode, S2CSynchronizedDataBatchPacket::handle);
        VxPacketHandler.registerPacket(C2SMountInputPacket.class, "mount_input", C2SMountInputPacket::encode, C2SMountInputPacket::decode, C2SMountInputPacket::handle);
        VxPacketHandler.registerPacket(S2CVehicleStatePacket.class, "vehicle_state", S2CVehicleStatePacket::encode, S2CVehicleStatePacket::decode, S2CVehicleStatePacket::handle);
        VxPacketHandler.registerPacket(S2CSpawnBodyBatchPacket.class, "spawn_body_batch", S2CSpawnBodyBatchPacket::encode, S2CSpawnBodyBatchPacket::decode, S2CSpawnBodyBatchPacket::handle);
        VxPacketHandler.registerPacket(S2CRemoveBodyBatchPacket.class, "remove_body_batch", S2CRemoveBodyBatchPacket::encode, S2CRemoveBodyBatchPacket::decode, S2CRemoveBodyBatchPacket::handle);
        VxPacketHandler.registerPacket(S2CUpdateBodyStateBatchPacket.class, "update_body_state_batch", S2CUpdateBodyStateBatchPacket::encode, S2CUpdateBodyStateBatchPacket::decode, S2CUpdateBodyStateBatchPacket::handle);
        VxPacketHandler.registerPacket(S2CUpdateVerticesBatchPacket.class, "update_vertices_batch", S2CUpdateVerticesBatchPacket::encode, S2CUpdateVerticesBatchPacket::decode, S2CUpdateVerticesBatchPacket::handle);
        VxPacketHandler.registerPacket(VxPhysicsGunSyncPacket.class, "physics_gun_sync", VxPhysicsGunSyncPacket::encode, VxPhysicsGunSyncPacket::decode, VxPhysicsGunSyncPacket::handle);
        VxPacketHandler.registerPacket(VxMagnetizerActionPacket.class, "magnetizer_action", VxMagnetizerActionPacket::encode, VxMagnetizerActionPacket::decode, VxMagnetizerActionPacket::handle);
        VxPacketHandler.registerPacket(VxPhysicsGunActionPacket.class, "physics_gun_action", VxPhysicsGunActionPacket::encode, VxPhysicsGunActionPacket::decode, VxPhysicsGunActionPacket::handle);
        VxPacketHandler.registerPacket(VxBoxThrowerActionPacket.class, "box_thrower_action", VxBoxThrowerActionPacket::encode, VxBoxThrowerActionPacket::decode, VxBoxThrowerActionPacket::handle);
    }

    private static <MSG> PacketInfo<MSG> getPacketInfo(MSG message) {
        PacketInfo<?> info = PACKETS.get(message.getClass());
        return Objects.requireNonNull(info, "Unregistered packet type: " + message.getClass().getName());
    }

    public static <MSG> void sendToServer(MSG message) {
        PacketInfo<MSG> info = VxPacketHandler.getPacketInfo(message);
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        info.encoder.accept(message, buf);
        NetworkManager.sendToServer((ResourceLocation)info.id, (FriendlyByteBuf)buf);
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        PacketInfo<MSG> info = VxPacketHandler.getPacketInfo(message);
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        info.encoder.accept(message, buf);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)info.id, (FriendlyByteBuf)buf);
    }

    public static <MSG> void sendToDimension(MSG message, ResourceKey<Level> dimensionKey) {
        ServerLevel level;
        if (GameInstance.getServer() != null && (level = GameInstance.getServer().m_129880_(dimensionKey)) != null) {
            PacketInfo<MSG> info = VxPacketHandler.getPacketInfo(message);
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            info.encoder.accept(message, buf);
            NetworkManager.sendToPlayers((Iterable)level.m_6907_(), (ResourceLocation)info.id, (FriendlyByteBuf)buf);
        }
    }

    public static <MSG> void sendToAll(MSG message) {
        if (GameInstance.getServer() != null) {
            PacketInfo<MSG> info = VxPacketHandler.getPacketInfo(message);
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            info.encoder.accept(message, buf);
            NetworkManager.sendToPlayers((Iterable)GameInstance.getServer().m_6846_().m_11314_(), (ResourceLocation)info.id, (FriendlyByteBuf)buf);
        }
    }

    private record PacketInfo<T>(ResourceLocation id, BiConsumer<T, FriendlyByteBuf> encoder) {
    }
}

