/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics;

import dev.architectury.event.events.common.TickEvent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.xmx.velthoric.event.api.VxLevelEvent;
import net.xmx.velthoric.event.api.VxServerLifecycleEvent;
import net.xmx.velthoric.physics.persistence.VxPersistenceManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class VxLifecycleEvents {
    public static void registerEvents() {
        VxServerLifecycleEvent.Starting.EVENT.register(VxLifecycleEvents::onServerStarting);
        VxLevelEvent.Load.EVENT.register(VxLifecycleEvents::onLevelLoad);
        VxLevelEvent.Unload.EVENT.register(VxLifecycleEvents::onLevelUnload);
        VxServerLifecycleEvent.Stopping.EVENT.register(VxLifecycleEvents::onServerStopping);
        TickEvent.SERVER_LEVEL_PRE.register(VxLifecycleEvents::onLevelTick);
    }

    private static void onServerStarting(VxServerLifecycleEvent.Starting event) {
        VxPersistenceManager.initialize();
    }

    private static void onServerStopping(VxServerLifecycleEvent.Stopping event) {
        VxPhysicsWorld.shutdownAll();
        VxPersistenceManager.shutdown();
    }

    private static void onLevelLoad(VxLevelEvent.Load event) {
        ServerLevel level = event.getLevel();
        if (!level.m_5776_()) {
            VxPhysicsWorld.getOrCreate(level);
        }
    }

    private static void onLevelUnload(VxLevelEvent.Unload event) {
        ServerLevel level = event.getLevel();
        if (!level.m_5776_()) {
            VxPhysicsWorld.shutdown((ResourceKey<Level>)level.m_46472_());
        }
    }

    private static void onLevelTick(ServerLevel level) {
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)level.m_46472_());
        if (physicsWorld != null && physicsWorld.isRunning()) {
            physicsWorld.onGameTick(level);
        }
    }
}

