/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.client.renderer;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.event.api.VxRenderEvent;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.mixin.impl.culling.LevelRendererAccessor;
import net.xmx.velthoric.mixin.impl.debug.EntityRenderDispatcherAccessor;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;
import net.xmx.velthoric.physics.body.client.VxRenderState;
import net.xmx.velthoric.physics.body.client.body.renderer.VxBodyRenderer;
import net.xmx.velthoric.physics.body.client.renderer.VxDebugRenderer;
import net.xmx.velthoric.physics.body.registry.VxBodyRegistry;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.body.type.VxSoftBody;

public class VxPhysicsRenderer {
    private static final float CULLING_BOUNDS_INFLATION = 2.0f;
    private static final VxRenderState finalRenderState = new VxRenderState();
    private static final RVec3 interpolatedPosition = new RVec3();
    private static final Quat interpolatedRotation = new Quat();
    private static final VxDebugRenderer debugRenderer = new VxDebugRenderer();

    public static void registerEvents() {
        VxRenderEvent.ClientRenderLevelStageEvent.EVENT.register(VxPhysicsRenderer::onRenderLevelStage);
    }

    private static void onRenderLevelStage(VxRenderEvent.ClientRenderLevelStageEvent event) {
        if (event.getStage() != VxRenderEvent.ClientRenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.m_91288_() == null) {
            return;
        }
        VxClientBodyManager manager = VxClientBodyManager.getInstance();
        if (manager.getAllBodies().isEmpty()) {
            return;
        }
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        PoseStack poseStack = event.getPoseStack();
        float partialTicks = event.getPartialTick();
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        Frustum frustum = ((LevelRendererAccessor)mc.f_91060_).velthoric_getCullingFrustum();
        poseStack.m_85836_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        for (VxBody body : manager.getAllBodies()) {
            try {
                int packedLight;
                AABB objectAABB;
                if (!body.isInitialized() || !frustum.m_113029_(objectAABB = body.getCullingAABB(2.0f))) continue;
                body.calculateRenderState(partialTicks, finalRenderState, interpolatedPosition, interpolatedRotation);
                if (body instanceof VxSoftBody && VxPhysicsRenderer.finalRenderState.vertexData != null && VxPhysicsRenderer.finalRenderState.vertexData.length >= 3) {
                    packedLight = LevelRenderer.m_109541_((BlockAndTintGetter)mc.f_91073_, (BlockPos)BlockPos.m_274561_((double)VxPhysicsRenderer.finalRenderState.vertexData[0], (double)VxPhysicsRenderer.finalRenderState.vertexData[1], (double)VxPhysicsRenderer.finalRenderState.vertexData[2]));
                } else {
                    RVec3 renderPosition = VxPhysicsRenderer.finalRenderState.transform.getTranslation();
                    packedLight = LevelRenderer.m_109541_((BlockAndTintGetter)mc.f_91073_, (BlockPos)BlockPos.m_274561_((double)renderPosition.xx(), (double)renderPosition.yy(), (double)renderPosition.zz()));
                }
                VxPhysicsRenderer.renderBody(body, poseStack, bufferSource, partialTicks, packedLight, finalRenderState);
            }
            catch (Exception e) {
                VxMainClass.LOGGER.error("Error rendering physics body {}", (Object)body.getPhysicsId(), (Object)e);
            }
        }
        if (((EntityRenderDispatcherAccessor)mc.m_91290_()).getRenderHitBoxes()) {
            debugRenderer.render(poseStack, (MultiBufferSource)bufferSource, manager, partialTicks);
        }
        poseStack.m_85849_();
        bufferSource.m_109911_();
    }

    private static void renderBody(VxBody body, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, float partialTicks, int packedLight, VxRenderState renderState) {
        ResourceLocation typeId = body.getTypeId();
        VxBodyRenderer<?> renderer = VxBodyRegistry.getInstance().getClientRenderer(typeId);
        if (renderer != null) {
            renderer.render(body, poseStack, bufferSource, partialTicks, packedLight, renderState);
        } else {
            VxMainClass.LOGGER.warn("No renderer registered for physics body type: {}", (Object)typeId);
        }
    }
}

