/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.manager;

import com.github.stephengold.joltjni.enumerate.EActivation;
import com.github.stephengold.joltjni.enumerate.EBodyType;
import com.github.stephengold.joltjni.enumerate.EMotionType;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.manager.VxBodyDataStore;
import net.xmx.velthoric.physics.body.manager.VxJoltBridge;
import net.xmx.velthoric.physics.body.manager.VxNetworkDispatcher;
import net.xmx.velthoric.physics.body.manager.VxPhysicsUpdater;
import net.xmx.velthoric.physics.body.manager.VxRemovalReason;
import net.xmx.velthoric.physics.body.manager.chunk.VxChunkManager;
import net.xmx.velthoric.physics.body.persistence.VxBodyStorage;
import net.xmx.velthoric.physics.body.persistence.VxSerializedBodyData;
import net.xmx.velthoric.physics.body.registry.VxBodyRegistry;
import net.xmx.velthoric.physics.body.registry.VxBodyType;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.body.type.VxRigidBody;
import net.xmx.velthoric.physics.body.type.VxSoftBody;
import net.xmx.velthoric.physics.persistence.VxAbstractRegionStorage;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.jetbrains.annotations.Nullable;

public class VxBodyManager {
    private final VxPhysicsWorld world;
    private final VxBodyStorage bodyStorage;
    private final VxBodyDataStore dataStore;
    private final VxPhysicsUpdater physicsUpdater;
    private final VxNetworkDispatcher networkDispatcher;
    private final VxChunkManager chunkManager;
    private final Map<UUID, VxBody> managedBodies = new ConcurrentHashMap<UUID, VxBody>();
    private final Int2ObjectMap<VxBody> joltBodyIdToVxBodyMap = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
    private final Deque<Integer> freeNetworkIds = new ArrayDeque<Integer>();
    private int nextNetworkId = 1;

    public VxBodyManager(VxPhysicsWorld world) {
        this.world = world;
        this.dataStore = new VxBodyDataStore();
        this.bodyStorage = new VxBodyStorage(world.getLevel(), this);
        this.physicsUpdater = new VxPhysicsUpdater(this);
        this.networkDispatcher = new VxNetworkDispatcher(world.getLevel(), this);
        this.chunkManager = new VxChunkManager(this);
    }

    public void initialize() {
        this.bodyStorage.initialize();
        this.networkDispatcher.start();
    }

    public void shutdown() {
        this.networkDispatcher.stop();
        VxMainClass.LOGGER.debug("Flushing physics body persistence for world {}...", (Object)this.world.getDimensionKey().m_135782_());
        this.flushPersistence(true);
        VxMainClass.LOGGER.debug("Physics body persistence flushed for world {}.", (Object)this.world.getDimensionKey().m_135782_());
        this.clear();
        this.bodyStorage.shutdown();
    }

    private void clear() {
        this.managedBodies.clear();
        this.joltBodyIdToVxBodyMap.clear();
        this.freeNetworkIds.clear();
        this.nextNetworkId = 1;
        this.dataStore.clear();
    }

    public void onPhysicsTick(VxPhysicsWorld world) {
        this.physicsUpdater.onPhysicsTick(world);
    }

    public void onGameTick(ServerLevel level) {
        this.networkDispatcher.onGameTick();
        this.physicsUpdater.onGameTick(level);
    }

    @Nullable
    public <T extends VxRigidBody> T createRigidBody(VxBodyType<T> type, VxTransform transform, Consumer<T> configurator) {
        return this.createRigidBody(type, transform, EActivation.DontActivate, configurator);
    }

    @Nullable
    public <T extends VxRigidBody> T createRigidBody(VxBodyType<T> type, VxTransform transform, EActivation activation, Consumer<T> configurator) {
        VxRigidBody body = (VxRigidBody)type.create(this.world, UUID.randomUUID());
        if (body == null) {
            return null;
        }
        configurator.accept(body);
        this.addConstructedBody(body, activation, transform);
        return (T)body;
    }

    @Nullable
    public <T extends VxSoftBody> T createSoftBody(VxBodyType<T> type, VxTransform transform, Consumer<T> configurator) {
        return this.createSoftBody(type, transform, EActivation.DontActivate, configurator);
    }

    @Nullable
    public <T extends VxSoftBody> T createSoftBody(VxBodyType<T> type, VxTransform transform, EActivation activation, Consumer<T> configurator) {
        VxSoftBody body = (VxSoftBody)type.create(this.world, UUID.randomUUID());
        if (body == null) {
            return null;
        }
        configurator.accept(body);
        this.addConstructedBody(body, activation, transform);
        return (T)body;
    }

    public void addConstructedBody(VxBody body, EActivation activation, VxTransform transform) {
        this.addInternal(body);
        int index = body.getDataStoreIndex();
        if (index != -1) {
            this.dataStore.posX[index] = transform.getTranslation().x();
            this.dataStore.posY[index] = transform.getTranslation().y();
            this.dataStore.posZ[index] = transform.getTranslation().z();
            this.dataStore.rotX[index] = transform.getRotation().getX();
            this.dataStore.rotY[index] = transform.getRotation().getY();
            this.dataStore.rotZ[index] = transform.getRotation().getZ();
            this.dataStore.rotW[index] = transform.getRotation().getW();
        }
        this.world.getMountingManager().onBodyAdded(body);
        this.networkDispatcher.onBodyAdded(body);
        if (body instanceof VxRigidBody) {
            VxRigidBody rigidBody = (VxRigidBody)body;
            VxJoltBridge.INSTANCE.createAndAddJoltRigidBody(rigidBody, this, null, null, activation, EMotionType.Dynamic);
        } else if (body instanceof VxSoftBody) {
            VxSoftBody softBody = (VxSoftBody)body;
            VxJoltBridge.INSTANCE.createAndAddJoltSoftBody(softBody, this, activation);
        }
    }

    @Nullable
    public VxBody addSerializedBody(VxSerializedBodyData data) {
        EActivation activation;
        if (this.managedBodies.containsKey(data.id())) {
            return this.managedBodies.get(data.id());
        }
        VxBody body = VxBodyRegistry.getInstance().create(data.typeId(), this.world, data.id());
        if (body == null) {
            VxMainClass.LOGGER.error("Failed to create body of type {} with ID {} from storage.", (Object)data.typeId(), (Object)data.id());
            return null;
        }
        this.addInternal(body);
        int index = body.getDataStoreIndex();
        boolean shouldActivate = data.linearVelocity().lengthSq() > 1.0E-4f || data.angularVelocity().lengthSq() > 1.0E-4f;
        EActivation eActivation = activation = shouldActivate ? EActivation.Activate : EActivation.DontActivate;
        if (index != -1) {
            this.dataStore.motionType[index] = data.motionType();
            this.dataStore.posX[index] = data.transform().getTranslation().x();
            this.dataStore.posY[index] = data.transform().getTranslation().y();
            this.dataStore.posZ[index] = data.transform().getTranslation().z();
            this.dataStore.rotX[index] = data.transform().getRotation().getX();
            this.dataStore.rotY[index] = data.transform().getRotation().getY();
            this.dataStore.rotZ[index] = data.transform().getRotation().getZ();
            this.dataStore.rotW[index] = data.transform().getRotation().getW();
        }
        body.readPersistenceData(data.persistenceData());
        data.persistenceData().release();
        this.world.getMountingManager().onBodyAdded(body);
        this.networkDispatcher.onBodyAdded(body);
        if (body instanceof VxRigidBody) {
            VxRigidBody rigidBody = (VxRigidBody)body;
            VxJoltBridge.INSTANCE.createAndAddJoltRigidBody(rigidBody, this, data.linearVelocity(), data.angularVelocity(), activation, data.motionType());
        } else if (body instanceof VxSoftBody) {
            VxSoftBody softBody = (VxSoftBody)body;
            VxJoltBridge.INSTANCE.createAndAddJoltSoftBody(softBody, this, activation);
        }
        return body;
    }

    public void removeBody(UUID id, VxRemovalReason reason) {
        VxBody body = this.managedBodies.get(id);
        if (body == null) {
            if (reason == VxRemovalReason.DISCARD) {
                this.bodyStorage.removeData(id);
            }
            this.world.getConstraintManager().removeConstraintsForBody(id, reason == VxRemovalReason.DISCARD);
            return;
        }
        this.processBodyRemoval(body, reason);
    }

    private void processBodyRemoval(VxBody body, VxRemovalReason reason) {
        this.managedBodies.remove(body.getPhysicsId());
        if (reason == VxRemovalReason.SAVE) {
            this.bodyStorage.storeBody(body);
        } else if (reason == VxRemovalReason.DISCARD) {
            this.bodyStorage.removeData(body.getPhysicsId());
        }
        this.world.getMountingManager().onBodyRemoved(body);
        this.networkDispatcher.onBodyRemoved(body);
        if (reason != VxRemovalReason.UNLOAD) {
            this.chunkManager.stopTracking(body);
        }
        body.onBodyRemoved(this.world, reason);
        this.world.getConstraintManager().removeConstraintsForBody(body.getPhysicsId(), reason == VxRemovalReason.DISCARD);
        VxJoltBridge.INSTANCE.destroyJoltBody(this.world, body.getBodyId());
        if (body.getNetworkId() != -1) {
            this.freeNetworkIds.add(body.getNetworkId());
        }
        this.dataStore.removeBody(body.getPhysicsId());
        if (body.getBodyId() != 0) {
            this.joltBodyIdToVxBodyMap.remove(body.getBodyId());
        }
        body.setDataStoreIndex(-1);
        body.setNetworkId(-1);
    }

    private void addInternal(VxBody body) {
        if (body == null) {
            return;
        }
        this.managedBodies.computeIfAbsent(body.getPhysicsId(), id -> {
            int n;
            EBodyType type = body instanceof VxSoftBody ? EBodyType.SoftBody : EBodyType.RigidBody;
            int index = this.dataStore.addBody((UUID)id, type);
            body.setDataStoreIndex(index);
            if (this.freeNetworkIds.isEmpty()) {
                int n2 = this.nextNetworkId;
                n = n2;
                this.nextNetworkId = n2 + 1;
            } else {
                n = this.freeNetworkIds.pop();
            }
            int networkId = n;
            body.setNetworkId(networkId);
            this.dataStore.networkId[index] = networkId;
            this.dataStore.isActive[index] = true;
            this.chunkManager.startTracking(body);
            return body;
        });
    }

    public void onChunkUnload(ChunkPos chunkPos) {
        List<VxBody> bodiesToUnload = this.chunkManager.removeAllInChunk(chunkPos);
        if (bodiesToUnload.isEmpty()) {
            return;
        }
        for (VxBody body : bodiesToUnload) {
            this.processBodyRemoval(body, VxRemovalReason.UNLOAD);
        }
    }

    @Nullable
    public VxBody getByJoltBodyId(int bodyId) {
        return (VxBody)this.joltBodyIdToVxBodyMap.get(bodyId);
    }

    @Nullable
    public VxBody getVxBody(UUID id) {
        return this.managedBodies.get(id);
    }

    public Collection<VxBody> getAllBodies() {
        return this.managedBodies.values();
    }

    public void getTransform(int dataStoreIndex, VxTransform out) {
        if (dataStoreIndex >= 0 && dataStoreIndex < this.dataStore.getCapacity()) {
            out.getTranslation().set(this.dataStore.posX[dataStoreIndex], this.dataStore.posY[dataStoreIndex], this.dataStore.posZ[dataStoreIndex]);
            out.getRotation().set(this.dataStore.rotX[dataStoreIndex], this.dataStore.rotY[dataStoreIndex], this.dataStore.rotZ[dataStoreIndex], this.dataStore.rotW[dataStoreIndex]);
        }
    }

    public ChunkPos getBodyChunkPos(int dataStoreIndex) {
        if (dataStoreIndex >= 0 && dataStoreIndex < this.dataStore.getCapacity()) {
            return new ChunkPos(SectionPos.m_175552_((double)this.dataStore.posX[dataStoreIndex]), SectionPos.m_175552_((double)this.dataStore.posZ[dataStoreIndex]));
        }
        return new ChunkPos(0, 0);
    }

    public void markCustomDataDirty(VxBody body) {
        if (body.getDataStoreIndex() != -1) {
            this.getDataStore().isCustomDataDirty[body.getDataStoreIndex()] = true;
        }
    }

    public void registerJoltBodyId(int bodyId, VxBody body) {
        this.joltBodyIdToVxBodyMap.put(bodyId, (Object)body);
    }

    public void saveBodiesInChunk(ChunkPos pos) {
        ArrayList bodiesInChunk = new ArrayList();
        this.chunkManager.forEachBodyInChunk(pos, bodiesInChunk::add);
        if (bodiesInChunk.isEmpty()) {
            return;
        }
        this.world.execute(() -> {
            HashMap<VxAbstractRegionStorage.RegionPos, Map<UUID, byte[]>> dataByRegion = new HashMap<VxAbstractRegionStorage.RegionPos, Map<UUID, byte[]>>();
            for (VxBody body : bodiesInChunk) {
                byte[] snapshot;
                int index = body.getDataStoreIndex();
                if (index == -1 || (snapshot = this.bodyStorage.serializeBodyData(body, index)) == null) continue;
                ChunkPos chunkPos = this.getBodyChunkPos(index);
                VxAbstractRegionStorage.RegionPos regionPos = new VxAbstractRegionStorage.RegionPos(chunkPos.f_45578_ >> 5, chunkPos.f_45579_ >> 5);
                dataByRegion.computeIfAbsent(regionPos, k -> new HashMap()).put(body.getPhysicsId(), snapshot);
            }
            if (!dataByRegion.isEmpty()) {
                this.bodyStorage.storeBodyBatch(dataByRegion);
            }
        });
    }

    public void flushPersistence(boolean block) {
        try {
            CompletableFuture<Void> future = this.bodyStorage.saveDirtyRegions();
            this.bodyStorage.getRegionIndex().save();
            if (block) {
                future.join();
            }
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Failed to flush physics body persistence for world {}", (Object)this.world.getLevel().m_46472_().m_135782_(), (Object)e);
        }
    }

    public VxPhysicsWorld getPhysicsWorld() {
        return this.world;
    }

    public VxBodyDataStore getDataStore() {
        return this.dataStore;
    }

    public VxBodyStorage getBodyStorage() {
        return this.bodyStorage;
    }

    public VxNetworkDispatcher getNetworkDispatcher() {
        return this.networkDispatcher;
    }

    public VxChunkManager getChunkManager() {
        return this.chunkManager;
    }
}

