/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.packet.batch;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.network.VxPacketUtils;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;
import net.xmx.velthoric.physics.body.packet.VxSpawnData;

public class S2CSpawnBodyBatchPacket {
    private final List<VxSpawnData> spawnDataList;

    public S2CSpawnBodyBatchPacket(List<VxSpawnData> spawnDataList) {
        this.spawnDataList = spawnDataList;
    }

    public static void encode(S2CSpawnBodyBatchPacket msg, FriendlyByteBuf buf) {
        FriendlyByteBuf tempBuf = new FriendlyByteBuf(Unpooled.buffer());
        try {
            tempBuf.m_130130_(msg.spawnDataList.size());
            for (VxSpawnData data : msg.spawnDataList) {
                data.encode(tempBuf);
            }
            byte[] uncompressedData = new byte[tempBuf.readableBytes()];
            tempBuf.readBytes(uncompressedData);
            byte[] compressedData = VxPacketUtils.compress(uncompressedData);
            buf.m_130130_(uncompressedData.length);
            buf.m_130087_(compressedData);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to compress spawn body batch packet", e);
        }
        finally {
            tempBuf.release();
        }
    }

    public static S2CSpawnBodyBatchPacket decode(FriendlyByteBuf buf) {
        int uncompressedSize = buf.m_130242_();
        byte[] compressedData = buf.m_130052_();
        try {
            byte[] decompressedData = VxPacketUtils.decompress(compressedData, uncompressedSize);
            FriendlyByteBuf decompressedBuf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])decompressedData));
            int size = decompressedBuf.m_130242_();
            ObjectArrayList spawnDataList = new ObjectArrayList(size);
            for (int i = 0; i < size; ++i) {
                spawnDataList.add(new VxSpawnData(decompressedBuf));
            }
            return new S2CSpawnBodyBatchPacket((List<VxSpawnData>)spawnDataList);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to decompress spawn body batch packet", e);
        }
    }

    public static void handle(S2CSpawnBodyBatchPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            VxClientBodyManager manager = VxClientBodyManager.getInstance();
            for (VxSpawnData data : msg.spawnDataList) {
                VxByteBuf dataBuf = new VxByteBuf(Unpooled.wrappedBuffer((byte[])data.data));
                try {
                    manager.spawnBody(data.id, data.networkId, data.typeIdentifier, dataBuf, data.timestamp);
                }
                finally {
                    if (dataBuf.refCnt() <= 0) continue;
                    dataBuf.release();
                }
            }
        });
    }
}

