/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.packet.batch;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.xmx.velthoric.network.VxPacketUtils;
import net.xmx.velthoric.physics.body.client.VxClientBodyDataStore;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;
import org.jetbrains.annotations.Nullable;

public class S2CUpdateVerticesBatchPacket {
    private final int count;
    private final int[] networkIds;
    private final float[][] vertexData;

    public S2CUpdateVerticesBatchPacket(int count, int[] networkIds, float[] @Nullable [] vertexData) {
        this.count = count;
        this.networkIds = networkIds;
        this.vertexData = vertexData;
    }

    public static void encode(S2CUpdateVerticesBatchPacket msg, FriendlyByteBuf buf) {
        FriendlyByteBuf tempBuf = new FriendlyByteBuf(Unpooled.buffer());
        try {
            tempBuf.m_130130_(msg.count);
            for (int i = 0; i < msg.count; ++i) {
                tempBuf.m_130130_(msg.networkIds[i]);
                float[] vertices = msg.vertexData[i];
                if (vertices != null && vertices.length > 0) {
                    tempBuf.writeBoolean(true);
                    tempBuf.m_130130_(vertices.length);
                    for (float v : vertices) {
                        tempBuf.writeFloat(v);
                    }
                    continue;
                }
                tempBuf.writeBoolean(false);
            }
            byte[] uncompressedData = new byte[tempBuf.readableBytes()];
            tempBuf.readBytes(uncompressedData);
            byte[] compressedData = VxPacketUtils.compress(uncompressedData);
            buf.m_130130_(uncompressedData.length);
            buf.m_130087_(compressedData);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to compress vertex batch packet", e);
        }
        finally {
            tempBuf.release();
        }
    }

    public static S2CUpdateVerticesBatchPacket decode(FriendlyByteBuf buf) {
        try {
            int uncompressedSize = buf.m_130242_();
            byte[] compressedData = buf.m_130052_();
            byte[] decompressedData = VxPacketUtils.decompress(compressedData, uncompressedSize);
            FriendlyByteBuf decompressedBuf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])decompressedData));
            int count = decompressedBuf.m_130242_();
            int[] networkIds = new int[count];
            float[][] vertexData = new float[count][];
            for (int i = 0; i < count; ++i) {
                networkIds[i] = decompressedBuf.m_130242_();
                if (decompressedBuf.readBoolean()) {
                    int length = decompressedBuf.m_130242_();
                    vertexData[i] = new float[length];
                    for (int j = 0; j < length; ++j) {
                        vertexData[i][j] = decompressedBuf.readFloat();
                    }
                    continue;
                }
                vertexData[i] = null;
            }
            return new S2CUpdateVerticesBatchPacket(count, networkIds, vertexData);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to decompress vertex batch packet", e);
        }
    }

    public static void handle(S2CUpdateVerticesBatchPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            VxClientBodyManager manager = VxClientBodyManager.getInstance();
            VxClientBodyDataStore store = manager.getStore();
            for (int i = 0; i < msg.count; ++i) {
                Integer index = store.getIndexForNetworkId(msg.networkIds[i]);
                if (index == null) continue;
                store.state1_vertexData[index.intValue()] = msg.vertexData[i];
            }
        });
    }
}

