/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.persistence;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import net.minecraft.core.SectionPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.body.manager.VxBodyDataStore;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.body.persistence.VxBodyCodec;
import net.xmx.velthoric.physics.body.persistence.VxSerializedBodyData;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.persistence.VxAbstractRegionStorage;
import net.xmx.velthoric.physics.persistence.VxRegionIndex;
import org.jetbrains.annotations.Nullable;

public class VxBodyStorage
extends VxAbstractRegionStorage<UUID, byte[]> {
    private final VxBodyManager bodyManager;
    private final VxBodyDataStore dataStore;
    private final ConcurrentMap<Long, List<UUID>> chunkToUuidIndex = new ConcurrentHashMap<Long, List<UUID>>();
    private final ConcurrentMap<UUID, CompletableFuture<VxBody>> pendingLoads = new ConcurrentHashMap<UUID, CompletableFuture<VxBody>>();

    public VxBodyStorage(ServerLevel level, VxBodyManager bodyManager) {
        super(level, "body", "body");
        this.bodyManager = bodyManager;
        this.dataStore = bodyManager.getDataStore();
    }

    @Override
    protected VxRegionIndex createRegionIndex() {
        return new VxRegionIndex(this.storagePath, "body");
    }

    @Override
    protected void readRegionData(ByteBuf buffer, VxAbstractRegionStorage.RegionData<UUID, byte[]> regionData) {
        FriendlyByteBuf friendlyBuf = new FriendlyByteBuf(buffer);
        while (friendlyBuf.isReadable()) {
            UUID id = friendlyBuf.m_130259_();
            byte[] data = friendlyBuf.m_130052_();
            regionData.entries.put(id, data);
            this.indexBodyData(id, data);
        }
    }

    @Override
    protected void writeRegionData(ByteBuf buffer, Map<UUID, byte[]> entries) {
        FriendlyByteBuf friendlyBuf = new FriendlyByteBuf(buffer);
        for (Map.Entry<UUID, byte[]> entry : entries.entrySet()) {
            friendlyBuf.m_130077_(entry.getKey());
            friendlyBuf.m_130087_(entry.getValue());
        }
    }

    public void storeBody(VxBody body) {
        if (body == null || body.getDataStoreIndex() == -1) {
            return;
        }
        this.bodyManager.getPhysicsWorld().execute(() -> {
            int index = body.getDataStoreIndex();
            if (index == -1) {
                return;
            }
            byte[] snapshot = this.serializeBodyData(body, index);
            if (snapshot == null) {
                return;
            }
            ChunkPos chunkPos = this.bodyManager.getBodyChunkPos(index);
            VxAbstractRegionStorage.RegionPos regionPos = new VxAbstractRegionStorage.RegionPos(chunkPos.f_45578_ >> 5, chunkPos.f_45579_ >> 5);
            this.storeBodyBatch(regionPos, Map.of(body.getPhysicsId(), snapshot));
        });
    }

    public void storeBodyBatch(Map<VxAbstractRegionStorage.RegionPos, Map<UUID, byte[]>> snapshotsByRegion) {
        snapshotsByRegion.forEach(this::storeBodyBatch);
    }

    public void storeBodyBatch(VxAbstractRegionStorage.RegionPos regionPos, Map<UUID, byte[]> snapshotBatch) {
        if (snapshotBatch == null || snapshotBatch.isEmpty()) {
            return;
        }
        ((CompletableFuture)this.getRegion(regionPos).thenAcceptAsync(region -> {
            for (Map.Entry entry : snapshotBatch.entrySet()) {
                UUID bodyId = (UUID)entry.getKey();
                byte[] data = (byte[])entry.getValue();
                region.entries.put(bodyId, data);
                this.regionIndex.put(bodyId, regionPos);
                this.indexBodyData(bodyId, data);
            }
            region.dirty.set(true);
            this.saveRegion(regionPos);
        }, (Executor)this.ioExecutor)).exceptionally(ex -> {
            VxMainClass.LOGGER.error("Failed to queue body batch for storage in region {}", (Object)regionPos, ex);
            return null;
        });
    }

    public void loadBodiesInChunk(ChunkPos chunkPos) {
        VxAbstractRegionStorage.RegionPos regionPos = new VxAbstractRegionStorage.RegionPos(chunkPos.f_45578_ >> 5, chunkPos.f_45579_ >> 5);
        ((CompletableFuture)this.getRegion(regionPos).thenRunAsync(() -> {
            List idsToLoad = (List)this.chunkToUuidIndex.get(chunkPos.m_45588_());
            if (idsToLoad == null || idsToLoad.isEmpty()) {
                return;
            }
            for (UUID id : List.copyOf(idsToLoad)) {
                if (this.bodyManager.getVxBody(id) != null || this.pendingLoads.containsKey(id)) continue;
                this.loadBody(id);
            }
        }, this.ioExecutor)).exceptionally(ex -> {
            VxMainClass.LOGGER.error("Failed to load bodies in chunk {}", (Object)chunkPos, ex);
            return null;
        });
    }

    public CompletableFuture<VxBody> loadBody(UUID id) {
        VxBody existingBody = this.bodyManager.getVxBody(id);
        if (existingBody != null) {
            return CompletableFuture.completedFuture(existingBody);
        }
        return this.pendingLoads.computeIfAbsent(id, this::loadBodyAsync);
    }

    private CompletableFuture<VxBody> loadBodyAsync(UUID id) {
        VxAbstractRegionStorage.RegionPos regionPos = this.regionIndex.get(id);
        if (regionPos == null) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.getRegion(regionPos).thenApplyAsync(region -> (byte[])region.entries.get(id), (Executor)this.ioExecutor)).thenApplyAsync(this::deserializeBody, (Executor)this.ioExecutor)).thenComposeAsync(data -> {
            if (data == null) {
                return CompletableFuture.completedFuture(null);
            }
            CompletableFuture bodyFuture = new CompletableFuture();
            this.bodyManager.getPhysicsWorld().execute(() -> {
                try {
                    VxBody body = this.bodyManager.addSerializedBody((VxSerializedBodyData)data);
                    bodyFuture.complete(body);
                }
                catch (Exception e) {
                    bodyFuture.completeExceptionally(e);
                }
            });
            return bodyFuture;
        })).whenComplete((body, ex) -> {
            if (ex != null) {
                VxMainClass.LOGGER.error("Exception loading physics body {}", (Object)id, ex);
            }
            this.pendingLoads.remove(id);
        });
    }

    public void removeData(UUID id) {
        VxAbstractRegionStorage.RegionPos regionPos = this.regionIndex.get(id);
        if (regionPos == null) {
            return;
        }
        ((CompletableFuture)this.getRegion(regionPos).thenAcceptAsync(region -> {
            byte[] data = (byte[])region.entries.remove(id);
            if (data != null) {
                region.dirty.set(true);
                this.deIndexBody(id, data);
                this.regionIndex.remove(id);
            }
        }, (Executor)this.ioExecutor)).exceptionally(ex -> {
            VxMainClass.LOGGER.error("Failed to remove data for body {}", (Object)id, ex);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private VxSerializedBodyData deserializeBody(byte[] data) {
        if (data == null) {
            return null;
        }
        VxByteBuf buf = new VxByteBuf(Unpooled.wrappedBuffer((byte[])data));
        try {
            VxSerializedBodyData vxSerializedBodyData = VxBodyCodec.deserialize(buf);
            return vxSerializedBodyData;
        }
        finally {
            if (buf.refCnt() > 0) {
                buf.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public byte[] serializeBodyData(VxBody body, int index) {
        ByteBuf buffer = Unpooled.buffer();
        VxByteBuf friendlyBuf = new VxByteBuf(buffer);
        try {
            VxBodyCodec.serialize(body, index, this.dataStore, friendlyBuf);
            byte[] data = new byte[buffer.readableBytes()];
            buffer.readBytes(data);
            byte[] byArray = data;
            return byArray;
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Error during body serialization for {}", (Object)body.getPhysicsId(), (Object)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (buffer.refCnt() > 0) {
                buffer.release();
            }
        }
    }

    private void indexBodyData(UUID id, byte[] data) {
        long chunkKey = this.getChunkKeyFromData(data);
        this.chunkToUuidIndex.computeIfAbsent(chunkKey, k -> new CopyOnWriteArrayList()).add(id);
    }

    private void deIndexBody(UUID id, byte[] data) {
        long chunkKey = this.getChunkKeyFromData(data);
        List idList = (List)this.chunkToUuidIndex.get(chunkKey);
        if (idList != null) {
            idList.remove(id);
            if (idList.isEmpty()) {
                this.chunkToUuidIndex.remove(chunkKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getChunkKeyFromData(byte[] data) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])data));
        try {
            buf.m_130259_();
            buf.m_130277_();
            double posX = buf.readDouble();
            buf.readDouble();
            double posZ = buf.readDouble();
            int chunkX = SectionPos.m_175552_((double)posX);
            int chunkZ = SectionPos.m_175552_((double)posZ);
            long l = new ChunkPos(chunkX, chunkZ).m_45588_();
            return l;
        }
        finally {
            if (buf.refCnt() > 0) {
                buf.release();
            }
        }
    }
}

