/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.registry;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.physics.body.client.body.renderer.VxBodyRenderer;
import net.xmx.velthoric.physics.body.registry.VxBodyType;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.jetbrains.annotations.Nullable;

public class VxBodyRegistry {
    private static volatile VxBodyRegistry instance;
    private final Map<ResourceLocation, VxBodyType<?>> registeredTypes = new ConcurrentHashMap();

    private VxBodyRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VxBodyRegistry getInstance() {
        if (instance != null) return instance;
        Class<VxBodyRegistry> clazz = VxBodyRegistry.class;
        synchronized (VxBodyRegistry.class) {
            if (instance != null) return instance;
            instance = new VxBodyRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void register(VxBodyType<?> type) {
        if (this.registeredTypes.containsKey(type.getTypeId())) {
            VxMainClass.LOGGER.warn("VxBodyType '{}' is already registered. Overwriting.", (Object)type.getTypeId());
        }
        this.registeredTypes.put(type.getTypeId(), type);
    }

    @Nullable
    public VxBody create(ResourceLocation typeId, VxPhysicsWorld world, UUID id) {
        VxBodyType<?> type = this.registeredTypes.get(typeId);
        if (type == null) {
            VxMainClass.LOGGER.error("No VxBodyType registered for ID: {}", (Object)typeId);
            return null;
        }
        try {
            return type.create(world, id);
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Failed to create physics body of type {}", (Object)typeId, (Object)e);
            return null;
        }
    }

    @Nullable
    public VxBodyType<?> getRegistrationData(ResourceLocation typeId) {
        return this.registeredTypes.get(typeId);
    }

    public Map<ResourceLocation, VxBodyType<?>> getRegisteredTypes() {
        return Map.copyOf(this.registeredTypes);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClientFactory(ResourceLocation typeId, ClientFactory factory) {
        Client.clientFactories.put(typeId, factory);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClientRenderer(ResourceLocation typeId, VxBodyRenderer<?> renderer) {
        Client.clientRenderers.put(typeId, renderer);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public VxBody createClientBody(VxBodyType<?> type, UUID id) {
        if (type == null) {
            VxMainClass.LOGGER.error("Attempted to create client body with null type for ID: {}", (Object)id);
            return null;
        }
        ResourceLocation typeId = type.getTypeId();
        ClientFactory factory = Client.clientFactories.get(typeId);
        if (factory != null) {
            try {
                return factory.create(type, id);
            }
            catch (Exception e) {
                VxMainClass.LOGGER.error("Failed to create client body of type {}", (Object)typeId, (Object)e);
            }
        } else {
            VxMainClass.LOGGER.error("No client factory registered for VxBodyType ID: {}", (Object)typeId);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public VxBodyRenderer<?> getClientRenderer(ResourceLocation typeId) {
        return Client.clientRenderers.get(typeId);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class Client {
        private static final Map<ResourceLocation, ClientFactory> clientFactories = new ConcurrentHashMap<ResourceLocation, ClientFactory>();
        private static final Map<ResourceLocation, VxBodyRenderer<?>> clientRenderers = new ConcurrentHashMap();

        private Client() {
        }
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface ClientFactory {
        public VxBody create(VxBodyType<?> var1, UUID var2);
    }
}

