/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.util;

import com.github.stephengold.joltjni.ConvexHullShapeSettings;
import com.github.stephengold.joltjni.Jolt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public final class VxMesh2ConvexUtil {
    private static final float DEFAULT_TOLERANCE = 0.02f;

    private VxMesh2ConvexUtil() {
    }

    public static ConvexHullShapeSettings createHull(FloatBuffer vertexData) {
        return VxMesh2ConvexUtil.createHull(vertexData, 0.02f);
    }

    public static ConvexHullShapeSettings createHull(FloatBuffer vertexData, float tolerance) {
        ByteBuffer byteView = ByteBuffer.allocateDirect(vertexData.remaining() * 4).order(ByteOrder.nativeOrder());
        FloatBuffer copy = byteView.asFloatBuffer();
        copy.put(vertexData);
        vertexData.rewind();
        return VxMesh2ConvexUtil.createHull(byteView, 0, vertexData.limit() / 3, 12, tolerance);
    }

    public static ConvexHullShapeSettings createHull(ByteBuffer vertexData, int startOffset, int vertexCount, int stride) {
        return VxMesh2ConvexUtil.createHull(vertexData, startOffset, vertexCount, stride, 0.02f);
    }

    public static ConvexHullShapeSettings createHull(ByteBuffer vertexData, int startOffset, int vertexCount, int stride, float tolerance) {
        vertexData.order(ByteOrder.nativeOrder());
        HashSet<Long> visitedVoxels = new HashSet<Long>();
        ArrayList<Float> filteredPoints = new ArrayList<Float>(Math.min(vertexCount * 3, 1024));
        for (int i = 0; i < vertexCount; ++i) {
            long gz;
            long gy;
            int currentOffset = startOffset + i * stride;
            float x = vertexData.getFloat(currentOffset);
            float y = vertexData.getFloat(currentOffset + 4);
            float z = vertexData.getFloat(currentOffset + 8);
            long gx = (long)Math.floor(x / tolerance);
            long voxelHash = VxMesh2ConvexUtil.hashVoxel(gx, gy = (long)Math.floor(y / tolerance), gz = (long)Math.floor(z / tolerance));
            if (!visitedVoxels.add(voxelHash)) continue;
            filteredPoints.add(Float.valueOf(x));
            filteredPoints.add(Float.valueOf(y));
            filteredPoints.add(Float.valueOf(z));
        }
        if (filteredPoints.isEmpty()) {
            return null;
        }
        int numPoints = filteredPoints.size() / 3;
        FloatBuffer joltBuffer = Jolt.newDirectFloatBuffer(filteredPoints.size());
        Iterator iterator = filteredPoints.iterator();
        while (iterator.hasNext()) {
            float f = ((Float)iterator.next()).floatValue();
            joltBuffer.put(f);
        }
        joltBuffer.flip();
        return new ConvexHullShapeSettings(numPoints, joltBuffer);
    }

    private static long hashVoxel(long x, long y, long z) {
        long h = x * 73856093L;
        h ^= y * 19349663L;
        return h ^= z * 83492791L;
    }
}

