/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.buoyancy;

import net.xmx.velthoric.physics.body.AbstractDataStore;
import net.xmx.velthoric.physics.buoyancy.VxFluidType;

public final class VxBuoyancyDataStore
extends AbstractDataStore {
    private int count = 0;
    private int capacity = 0;
    public int[] bodyIds;
    public float[] surfaceHeights;
    public VxFluidType[] fluidTypes;

    public VxBuoyancyDataStore() {
        this(256);
    }

    public VxBuoyancyDataStore(int initialCapacity) {
        this.allocate(initialCapacity);
    }

    private void allocate(int newCapacity) {
        if (newCapacity <= this.capacity) {
            return;
        }
        this.bodyIds = this.grow(this.bodyIds, newCapacity);
        this.surfaceHeights = this.grow(this.surfaceHeights, newCapacity);
        this.fluidTypes = this.grow(this.fluidTypes, newCapacity);
        this.capacity = newCapacity;
    }

    public void add(int bodyId, float surfaceHeight, VxFluidType fluidType) {
        if (this.count == this.capacity) {
            this.allocate(this.capacity * 2);
        }
        this.bodyIds[this.count] = bodyId;
        this.surfaceHeights[this.count] = surfaceHeight;
        this.fluidTypes[this.count] = fluidType;
        ++this.count;
    }

    public int getCount() {
        return this.count;
    }

    public void clear() {
        this.count = 0;
    }
}

