/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.buoyancy.floater;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.MotionProperties;
import com.github.stephengold.joltjni.Plane;
import com.github.stephengold.joltjni.RMat44;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.ConstConvexShape;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import net.xmx.velthoric.physics.buoyancy.VxBuoyancyDataStore;
import net.xmx.velthoric.physics.buoyancy.VxFluidType;
import net.xmx.velthoric.physics.buoyancy.floater.VxBuoyancyFloater;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class VxBuoyancyConvexFloater
extends VxBuoyancyFloater {
    private static final float WATER_DENSITY = 1000.0f;
    private static final float LAVA_DENSITY = 3100.0f;
    private final ThreadLocal<Vec3> tempVec3_2 = ThreadLocal.withInitial(Vec3::new);
    private final ThreadLocal<Vec3> tempVec3_3 = ThreadLocal.withInitial(Vec3::new);
    private final ThreadLocal<RVec3> tempRVec3_1 = ThreadLocal.withInitial(RVec3::new);
    private final ThreadLocal<RVec3> tempRVec3_2 = ThreadLocal.withInitial(RVec3::new);
    private final ThreadLocal<Plane> tempPlane = ThreadLocal.withInitial(() -> new Plane(0.0f, 1.0f, 0.0f, 0.0f));
    private final ThreadLocal<float[]> tempFloatArray = ThreadLocal.withInitial(() -> new float[1]);
    private final ThreadLocal<Vec3> tempScale = ThreadLocal.withInitial(() -> new Vec3(1.0f, 1.0f, 1.0f));

    public VxBuoyancyConvexFloater(VxPhysicsWorld physicsWorld) {
        super(physicsWorld);
    }

    @Override
    public void applyForces(Body body, float deltaTime, int index, VxBuoyancyDataStore dataStore) {
        ConstConvexShape shape = (ConstConvexShape)body.getShape();
        RMat44 worldTransform = body.getCenterOfMassTransform();
        RVec3 comPosition = this.tempRVec3_1.get();
        body.getCenterOfMassPosition(comPosition);
        this.applyBuoyancyToConvexPart(body, shape, worldTransform, comPosition, deltaTime, index, dataStore);
    }

    public void applyBuoyancyToConvexPart(Body body, ConstConvexShape convexPart, RMat44 partWorldTransform, RVec3 bodyCom, float deltaTime, int index, VxBuoyancyDataStore dataStore) {
        float angularSpeed;
        float linearDragCoefficient;
        float surfaceY = dataStore.surfaceHeights[index];
        VxFluidType fluidType = dataStore.fluidTypes[index];
        float fluidDensity = fluidType == VxFluidType.LAVA ? 3100.0f : 1000.0f;
        float angularDragCoefficient = switch (fluidType) {
            case VxFluidType.LAVA -> {
                linearDragCoefficient = 5.0f;
                yield 2.0f;
            }
            default -> {
                linearDragCoefficient = 1.0f;
                yield 0.5f;
            }
        };
        Plane waterPlane = this.tempPlane.get();
        waterPlane.set(0.0f, 1.0f, 0.0f, -surfaceY);
        Vec3 scale = this.tempScale.get();
        float[] submergedVolumeArr = this.tempFloatArray.get();
        Vec3 centerOfBuoyancyWorld = this.tempVec3_2.get();
        convexPart.getSubmergedVolume(partWorldTransform.toMat44(), scale, waterPlane, submergedVolumeArr, submergedVolumeArr, centerOfBuoyancyWorld, bodyCom);
        float submergedVolume = Math.abs(submergedVolumeArr[0]);
        if (submergedVolume < 1.0E-6f) {
            return;
        }
        Vec3 gravity = this.physicsWorld.getPhysicsSystem().getGravity();
        Vec3 buoyancyImpulse = this.tempVec3_3.get();
        buoyancyImpulse.set(gravity);
        buoyancyImpulse.scaleInPlace(-1.0f * fluidDensity * submergedVolume * deltaTime);
        RVec3 impulsePosition = this.tempRVec3_2.get();
        impulsePosition.set(centerOfBuoyancyWorld);
        body.addImpulse(buoyancyImpulse, impulsePosition);
        MotionProperties motionProperties = body.getMotionProperties();
        Vec3 linearVelocity = motionProperties.getLinearVelocity();
        Vec3 angularVelocity = motionProperties.getAngularVelocity();
        RVec3 r = Op.minus((RVec3Arg)impulsePosition, bodyCom);
        Vec3 rotationalVelocityAtPoint = angularVelocity.cross(r.toVec3());
        Vec3 pointVelocity = Op.plus((Vec3Arg)linearVelocity, (Vec3Arg)rotationalVelocityAtPoint);
        float linearSpeed = pointVelocity.length();
        if (linearSpeed > 1.0E-6f) {
            float dragMagnitude = linearDragCoefficient * fluidDensity * submergedVolume * linearSpeed;
            Vec3 linearDragImpulse = Op.star(-dragMagnitude * deltaTime, (Vec3Arg)pointVelocity.normalized());
            body.addImpulse(linearDragImpulse, impulsePosition);
        }
        if ((angularSpeed = angularVelocity.length()) > 1.0E-6f) {
            float angularDragMagnitude = angularDragCoefficient * fluidDensity * submergedVolume * angularSpeed;
            Vec3 angularDragImpulse = Op.star(-angularDragMagnitude * deltaTime, (Vec3Arg)angularVelocity.normalized());
            body.addAngularImpulse(angularDragImpulse);
        }
    }
}

