/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.buoyancy.phase;

import com.github.stephengold.joltjni.enumerate.EMotionType;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.xmx.velthoric.physics.body.manager.VxBodyDataStore;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.buoyancy.VxBuoyancyDataStore;
import net.xmx.velthoric.physics.buoyancy.VxFluidType;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class VxBuoyancyBroadPhase {
    private final VxPhysicsWorld physicsWorld;
    private final ServerLevel level;

    public VxBuoyancyBroadPhase(VxPhysicsWorld physicsWorld) {
        this.physicsWorld = physicsWorld;
        this.level = physicsWorld.getLevel();
    }

    public void findPotentialFluidContacts(VxBuoyancyDataStore dataStore) {
        VxBodyDataStore ds = this.physicsWorld.getBodyManager().getDataStore();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < ds.getCapacity(); ++i) {
            VxBody vxBody;
            UUID id;
            float averageSurfaceHeight;
            if (ds.motionType[i] == EMotionType.Static || ds.getIdForIndex(i) == null || !ds.isActive[i]) continue;
            float minX = ds.aabbMinX[i];
            float minY = ds.aabbMinY[i];
            float minZ = ds.aabbMinZ[i];
            float maxX = ds.aabbMaxX[i];
            float maxY = ds.aabbMaxY[i];
            float maxZ = ds.aabbMaxZ[i];
            if (minX >= maxX || minY >= maxY || minZ >= maxZ) continue;
            float totalSurfaceHeight = 0.0f;
            int fluidColumnCount = 0;
            VxFluidType detectedType = null;
            int minBlockX = (int)Math.floor(minX);
            int maxBlockX = (int)Math.floor(maxX);
            int minBlockY = (int)Math.floor(minY);
            int maxBlockY = (int)Math.floor(maxY);
            int minBlockZ = (int)Math.floor(minZ);
            int maxBlockZ = (int)Math.floor(maxZ);
            for (int x = minBlockX; x <= maxBlockX; ++x) {
                block2: for (int z = minBlockZ; z <= maxBlockZ; ++z) {
                    LevelChunk chunk = this.level.m_7726_().m_7131_(x >> 4, z >> 4);
                    if (chunk == null) continue;
                    for (int y = maxBlockY; y >= minBlockY; --y) {
                        mutablePos.m_122178_(x, y, z);
                        FluidState fluidState = chunk.m_6425_((BlockPos)mutablePos);
                        if (fluidState.m_76178_()) continue;
                        totalSurfaceHeight += (float)y + fluidState.m_76155_((BlockGetter)this.level, (BlockPos)mutablePos);
                        ++fluidColumnCount;
                        if (fluidState.m_205070_(FluidTags.f_13131_)) {
                            detectedType = VxFluidType.WATER;
                            continue block2;
                        }
                        if (!fluidState.m_205070_(FluidTags.f_13132_)) continue block2;
                        detectedType = VxFluidType.LAVA;
                        continue block2;
                    }
                }
            }
            if (fluidColumnCount <= 0 || detectedType == null || !((averageSurfaceHeight = totalSurfaceHeight / (float)fluidColumnCount) > minY) || (id = ds.getIdForIndex(i)) == null || (vxBody = this.physicsWorld.getBodyManager().getVxBody(id)) == null) continue;
            dataStore.add(vxBody.getBodyId(), averageSurfaceHeight, detectedType);
        }
    }
}

