/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.mounting.entity;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.physics.mounting.manager.VxClientMountingManager;
import net.xmx.velthoric.physics.mounting.manager.VxMountingManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VxMountingEntity
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> PHYSICS_ID = SynchedEntityData.m_135353_(VxMountingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> SEAT_ID = SynchedEntityData.m_135353_(VxMountingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public VxMountingEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
        this.f_19850_ = false;
        this.m_20242_(true);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.m_20197_().isEmpty()) {
                this.m_146870_();
                return;
            }
            this.restoreMountingLinkIfNeeded();
        }
    }

    private void restoreMountingLinkIfNeeded() {
        Entity entity = this.m_146895_();
        if (entity instanceof ServerPlayer) {
            VxMountingManager manager;
            VxPhysicsWorld physicsWorld;
            ServerPlayer player = (ServerPlayer)entity;
            Optional<UUID> physicsIdOpt = this.getPhysicsId();
            Optional<UUID> seatIdOpt = this.getSeatId();
            if (physicsIdOpt.isPresent() && seatIdOpt.isPresent() && (physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)this.m_9236_().m_46472_())) != null && !(manager = physicsWorld.getMountingManager()).isMounting(player)) {
                manager.restoreMounting(player, physicsIdOpt.get(), seatIdOpt.get());
            }
        }
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_7334_(Entity entity) {
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_6478_(MoverType type, Vec3 pos) {
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6673_(DamageSource source) {
        return true;
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6783_(double distance) {
        return false;
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(PHYSICS_ID, Optional.empty());
        this.f_19804_.m_135372_(SEAT_ID, Optional.empty());
    }

    public Optional<UUID> getPhysicsId() {
        return (Optional)this.f_19804_.m_135370_(PHYSICS_ID);
    }

    public Optional<UUID> getSeatId() {
        return (Optional)this.f_19804_.m_135370_(SEAT_ID);
    }

    public Vector3f getMountPositionOffset() {
        if (this.m_9236_().m_5776_()) {
            return this.getPhysicsId().flatMap(objId -> this.getSeatId().flatMap(seatId -> VxClientMountingManager.INSTANCE.getSeat((UUID)objId, (UUID)seatId))).map(seat -> new Vector3f((Vector3fc)seat.getRiderOffset())).orElse(new Vector3f());
        }
        Entity entity = this.m_146895_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)this.m_9236_().m_46472_());
            if (physicsWorld != null) {
                VxMountingManager mountingManager = physicsWorld.getMountingManager();
                return mountingManager.getSeatForPlayer(player).map(seat -> new Vector3f((Vector3fc)seat.getRiderOffset())).orElse(new Vector3f());
            }
        }
        return new Vector3f();
    }

    public void setMountInfo(UUID physicsId, UUID seatId) {
        this.f_19804_.m_135381_(PHYSICS_ID, Optional.of(physicsId));
        this.f_19804_.m_135381_(SEAT_ID, Optional.of(seatId));
    }

    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        if (!this.m_9236_().m_5776_() && passenger instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)passenger;
            VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)this.m_9236_().m_46472_());
            if (physicsWorld != null) {
                physicsWorld.getMountingManager().stopMounting(player);
            }
        }
    }

    public boolean m_20145_() {
        return true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128403_("PhysicsId")) {
            this.f_19804_.m_135381_(PHYSICS_ID, Optional.of(compound.m_128342_("PhysicsId")));
        }
        if (compound.m_128403_("SeatId")) {
            this.f_19804_.m_135381_(SEAT_ID, Optional.of(compound.m_128342_("SeatId")));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        this.getPhysicsId().ifPresent(uuid -> compound.m_128362_("PhysicsId", uuid));
        this.getSeatId().ifPresent(uuid -> compound.m_128362_("SeatId", uuid));
    }
}

