/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.mounting.manager;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.xmx.velthoric.event.api.VxClientPlayerNetworkEvent;
import net.xmx.velthoric.physics.mounting.seat.VxSeat;

public enum VxClientMountingManager {
    INSTANCE;

    private final Map<UUID, Map<UUID, VxSeat>> bodyToSeatsMap = new ConcurrentHashMap<UUID, Map<UUID, VxSeat>>();

    public static void registerEvents() {
        VxClientPlayerNetworkEvent.LoggingOut.EVENT.register(event -> INSTANCE.clearAll());
    }

    public void addSeat(UUID physicsId, VxSeat seat) {
        this.bodyToSeatsMap.computeIfAbsent(physicsId, k -> new ConcurrentHashMap()).put(seat.getId(), seat);
    }

    public void removeSeatsForBody(UUID physicsId) {
        this.bodyToSeatsMap.remove(physicsId);
    }

    public Collection<VxSeat> getSeats(UUID physicsId) {
        Map<UUID, VxSeat> seats = this.bodyToSeatsMap.get(physicsId);
        return seats != null ? seats.values() : Collections.emptyList();
    }

    public Optional<VxSeat> getSeat(UUID physicsId, UUID seatId) {
        Map<UUID, VxSeat> seats = this.bodyToSeatsMap.get(physicsId);
        return seats != null ? Optional.ofNullable(seats.get(seatId)) : Optional.empty();
    }

    public void clearAll() {
        this.bodyToSeatsMap.clear();
    }
}

