/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.ragdoll.body;

import com.github.stephengold.joltjni.BodyCreationSettings;
import com.github.stephengold.joltjni.BoxShapeSettings;
import com.github.stephengold.joltjni.ConvexShapeSettings;
import com.github.stephengold.joltjni.TaperedCapsuleShapeSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EMotionType;
import java.util.UUID;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.body.registry.VxBodyType;
import net.xmx.velthoric.physics.body.sync.VxDataAccessor;
import net.xmx.velthoric.physics.body.sync.VxDataSerializers;
import net.xmx.velthoric.physics.body.sync.VxSynchronizedData;
import net.xmx.velthoric.physics.body.type.VxRigidBody;
import net.xmx.velthoric.physics.body.type.factory.VxRigidBodyFactory;
import net.xmx.velthoric.physics.ragdoll.VxBodyPart;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class VxBodyPartRigidBody
extends VxRigidBody {
    public static final VxDataAccessor<Vec3> DATA_HALF_EXTENTS = VxDataAccessor.create(VxBodyPartRigidBody.class, VxDataSerializers.VEC3);
    public static final VxDataAccessor<VxBodyPart> DATA_BODY_PART = VxDataAccessor.create(VxBodyPartRigidBody.class, VxDataSerializers.BODY_PART);
    public static final VxDataAccessor<String> DATA_SKIN_ID = VxDataAccessor.create(VxBodyPartRigidBody.class, VxDataSerializers.STRING);

    public VxBodyPartRigidBody(VxBodyType<VxBodyPartRigidBody> type, VxPhysicsWorld world, UUID id) {
        super((VxBodyType<? extends VxRigidBody>)type, world, id);
    }

    @OnlyIn(value=Dist.CLIENT)
    public VxBodyPartRigidBody(VxBodyType<VxBodyPartRigidBody> type, UUID id) {
        super((VxBodyType<? extends VxRigidBody>)type, id);
    }

    @Override
    protected void defineSyncData(VxSynchronizedData.Builder builder) {
        builder.define(DATA_HALF_EXTENTS, new Vec3(0.25f, 0.25f, 0.25f));
        builder.define(DATA_BODY_PART, VxBodyPart.TORSO);
        builder.define(DATA_SKIN_ID, "");
    }

    @Override
    public int createJoltBody(VxRigidBodyFactory factory) {
        VxBodyPart partType = this.getSyncData(DATA_BODY_PART);
        Vec3 fullSize = partType.getSize();
        ConvexShapeSettings shapeSettings = switch (partType) {
            case VxBodyPart.TORSO -> {
                Vec3 halfExtents = new Vec3(fullSize.getX() * 0.5f, fullSize.getY() * 0.5f, fullSize.getZ() * 0.5f);
                float convexRadius = 0.1f;
                yield new BoxShapeSettings(halfExtents, convexRadius);
            }
            default -> {
                float baseRadius;
                float halfHeight = fullSize.getY() / 2.0f;
                float topRadius = baseRadius = (fullSize.getX() + fullSize.getZ()) / 4.0f;
                float bottomRadius = baseRadius;
                if (partType == VxBodyPart.LEFT_ARM || partType == VxBodyPart.RIGHT_ARM || partType == VxBodyPart.LEFT_LEG || partType == VxBodyPart.RIGHT_LEG) {
                    topRadius = baseRadius * 1.1f;
                    bottomRadius = baseRadius * 0.9f;
                }
                float capsuleHalfHeight = Math.max(0.01f, halfHeight - Math.max(topRadius, bottomRadius));
                yield new TaperedCapsuleShapeSettings(capsuleHalfHeight, topRadius, bottomRadius);
            }
        };
        try {
            int n;
            try (BodyCreationSettings bcs = new BodyCreationSettings();){
                bcs.setMotionType(EMotionType.Dynamic);
                bcs.setObjectLayer(1);
                bcs.setFriction(0.5f);
                bcs.setRestitution(0.3f);
                n = factory.create(shapeSettings, bcs);
            }
            return n;
        }
        finally {
            shapeSettings.close();
        }
    }

    @Override
    public void writePersistenceData(VxByteBuf buf) {
        super.writePersistenceData(buf);
        VxDataSerializers.VEC3.write(buf, this.getSyncData(DATA_HALF_EXTENTS));
        VxDataSerializers.BODY_PART.write(buf, this.getSyncData(DATA_BODY_PART));
        VxDataSerializers.STRING.write(buf, this.getSyncData(DATA_SKIN_ID));
    }

    @Override
    public void readPersistenceData(VxByteBuf buf) {
        super.readPersistenceData(buf);
        this.setSyncData(DATA_HALF_EXTENTS, VxDataSerializers.VEC3.read(buf));
        this.setSyncData(DATA_BODY_PART, VxDataSerializers.BODY_PART.read(buf));
        this.setSyncData(DATA_SKIN_ID, VxDataSerializers.STRING.read(buf));
    }
}

