/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.ragdoll.body;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.client.VxRenderState;
import net.xmx.velthoric.physics.body.client.body.renderer.VxRigidBodyRenderer;
import net.xmx.velthoric.physics.ragdoll.VxBodyPart;
import net.xmx.velthoric.physics.ragdoll.body.VxBodyPartRigidBody;
import org.joml.Quaternionf;

public class VxRagdollBodyPartRenderer
extends VxRigidBodyRenderer<VxBodyPartRigidBody> {
    private HumanoidModel<LivingEntity> model;
    private final Map<VxBodyPart, ModelPart> partMap = new EnumMap<VxBodyPart, ModelPart>(VxBodyPart.class);
    private boolean isInitialized = false;

    private void initialize() {
        ModelPart root = Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171162_);
        this.model = new HumanoidModel(root);
        this.partMap.put(VxBodyPart.HEAD, this.model.f_102808_);
        this.partMap.put(VxBodyPart.TORSO, this.model.f_102810_);
        this.partMap.put(VxBodyPart.LEFT_ARM, this.model.f_102812_);
        this.partMap.put(VxBodyPart.RIGHT_ARM, this.model.f_102811_);
        this.partMap.put(VxBodyPart.LEFT_LEG, this.model.f_102814_);
        this.partMap.put(VxBodyPart.RIGHT_LEG, this.model.f_102813_);
        this.isInitialized = true;
    }

    @Override
    public void render(VxBodyPartRigidBody body, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, float partialTicks, int packedLight, VxRenderState renderState) {
        VxBodyPart partType;
        ModelPart modelPart;
        if (!this.isInitialized) {
            this.initialize();
        }
        if ((modelPart = this.partMap.get((Object)(partType = body.getSyncData(VxBodyPartRigidBody.DATA_BODY_PART)))) == null) {
            return;
        }
        poseStack.m_85836_();
        VxTransform transform = renderState.transform;
        poseStack.m_252880_(transform.getTranslation().x(), transform.getTranslation().y(), transform.getTranslation().z());
        poseStack.m_252781_(new Quaternionf(transform.getRotation().getX(), transform.getRotation().getY(), transform.getRotation().getZ(), transform.getRotation().getW()));
        float scaleX = body.getSyncData(VxBodyPartRigidBody.DATA_HALF_EXTENTS).getX() * 2.0f / partType.getSize().getX();
        float scaleY = body.getSyncData(VxBodyPartRigidBody.DATA_HALF_EXTENTS).getY() * 2.0f / partType.getSize().getY();
        float scaleZ = body.getSyncData(VxBodyPartRigidBody.DATA_HALF_EXTENTS).getZ() * 2.0f / partType.getSize().getZ();
        poseStack.m_85841_(scaleX, scaleY, scaleZ);
        poseStack.m_85841_(1.0f, -1.0f, -1.0f);
        poseStack.m_252880_(-modelPart.f_104200_ / 16.0f, -modelPart.f_104201_ / 16.0f, -modelPart.f_104202_ / 16.0f);
        switch (partType) {
            case HEAD: {
                poseStack.m_85837_(0.0, 0.25, 0.0);
                break;
            }
            case TORSO: 
            case LEFT_LEG: 
            case RIGHT_LEG: {
                poseStack.m_85837_(0.0, -0.375, 0.0);
                break;
            }
            case LEFT_ARM: {
                poseStack.m_85837_(-0.0625, -0.25, 0.0);
                break;
            }
            case RIGHT_ARM: {
                poseStack.m_85837_(0.0625, -0.25, 0.0);
            }
        }
        ResourceLocation skinTexture = this.getSkinTexture(body);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)skinTexture));
        modelPart.m_104301_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
    }

    private ResourceLocation getSkinTexture(VxBodyPartRigidBody body) {
        String skinIdStr = body.getSyncData(VxBodyPartRigidBody.DATA_SKIN_ID);
        if (skinIdStr == null || skinIdStr.isEmpty()) {
            return DefaultPlayerSkin.m_118626_();
        }
        try {
            PlayerInfo playerInfo;
            UUID playerUuid = UUID.fromString(skinIdStr);
            if (Minecraft.m_91087_().m_91403_() != null && (playerInfo = Minecraft.m_91087_().m_91403_().m_104949_(playerUuid)) != null) {
                return playerInfo.m_105337_();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return DefaultPlayerSkin.m_118626_();
    }
}

