/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.terrain.storage;

import com.github.stephengold.joltjni.ShapeRefC;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.xmx.velthoric.physics.body.AbstractDataStore;
import net.xmx.velthoric.physics.terrain.VxSectionPos;
import org.jetbrains.annotations.Nullable;

public final class VxChunkDataStore
extends AbstractDataStore {
    private static final int INITIAL_CAPACITY = 4096;
    public static final int UNUSED_BODY_ID = 0;
    private final Object allocationLock = new Object();
    private final ConcurrentHashMap<VxSectionPos, Integer> posToIndex = new ConcurrentHashMap();
    private volatile AtomicReferenceArray<VxSectionPos> indexToPos;
    private final Deque<Integer> freeIndices = new ArrayDeque<Integer>();
    private int count = 0;
    private volatile int capacity = 0;
    private AtomicIntegerArray states;
    private AtomicIntegerArray bodyIds;
    private AtomicReferenceArray<ShapeRefC> shapeRefs;
    private AtomicIntegerArray isPlaceholder;
    private AtomicIntegerArray rebuildVersions;
    private AtomicIntegerArray referenceCounts;

    public VxChunkDataStore() {
        this.allocate(4096);
    }

    private void allocate(int newCapacity) {
        this.states = VxChunkDataStore.growAtomic(this.states, newCapacity);
        this.bodyIds = VxChunkDataStore.growAtomic(this.bodyIds, newCapacity);
        this.shapeRefs = VxChunkDataStore.growAtomic(this.shapeRefs, newCapacity);
        this.isPlaceholder = VxChunkDataStore.growAtomic(this.isPlaceholder, newCapacity, 1);
        this.rebuildVersions = VxChunkDataStore.growAtomic(this.rebuildVersions, newCapacity);
        this.referenceCounts = VxChunkDataStore.growAtomic(this.referenceCounts, newCapacity);
        this.indexToPos = VxChunkDataStore.growAtomic(this.indexToPos, newCapacity);
        this.capacity = newCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addChunk(VxSectionPos pos) {
        Integer existingIndex = this.posToIndex.get(pos);
        if (existingIndex != null) {
            return existingIndex;
        }
        Object object = this.allocationLock;
        synchronized (object) {
            int n;
            existingIndex = this.posToIndex.get(pos);
            if (existingIndex != null) {
                return existingIndex;
            }
            if (this.count == this.capacity) {
                this.allocate(this.capacity + (this.capacity >> 1));
            }
            if (this.freeIndices.isEmpty()) {
                int n2 = this.count;
                n = n2;
                this.count = n2 + 1;
            } else {
                n = this.freeIndices.pop();
            }
            int index = n;
            this.posToIndex.put(pos, index);
            this.indexToPos.set(index, pos);
            this.resetIndex(index);
            return index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Integer removeChunk(VxSectionPos pos) {
        Object object = this.allocationLock;
        synchronized (object) {
            Integer index = this.posToIndex.remove(pos);
            if (index != null) {
                ShapeRefC shape = this.shapeRefs.getAndSet(index, null);
                if (shape != null) {
                    shape.close();
                }
                this.freeIndices.push(index);
                this.indexToPos.set(index, null);
                return index;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.allocationLock;
        synchronized (object) {
            for (int i = 0; i < this.count; ++i) {
                ShapeRefC shape = this.shapeRefs.get(i);
                if (shape == null) continue;
                shape.close();
            }
            this.posToIndex.clear();
            this.freeIndices.clear();
            this.count = 0;
            this.allocate(4096);
        }
    }

    public int getState(int index) {
        if (index < 0 || index >= this.capacity) {
            return 5;
        }
        return this.states.get(index);
    }

    public void setState(int index, int state) {
        if (index < 0 || index >= this.capacity) {
            return;
        }
        this.states.set(index, state);
    }

    public int getBodyId(int index) {
        if (index < 0 || index >= this.capacity) {
            return 0;
        }
        return this.bodyIds.get(index);
    }

    public void setBodyId(int index, int bodyId) {
        if (index < 0 || index >= this.capacity) {
            return;
        }
        this.bodyIds.set(index, bodyId);
    }

    public boolean isPlaceholder(int index) {
        if (index < 0 || index >= this.capacity) {
            return true;
        }
        return this.isPlaceholder.get(index) == 1;
    }

    public void setPlaceholder(int index, boolean placeholder) {
        if (index < 0 || index >= this.capacity) {
            return;
        }
        this.isPlaceholder.set(index, placeholder ? 1 : 0);
    }

    public int incrementAndGetRefCount(int index) {
        if (index < 0 || index >= this.capacity) {
            return 0;
        }
        return this.referenceCounts.incrementAndGet(index);
    }

    public int decrementAndGetRefCount(int index) {
        if (index < 0 || index >= this.capacity) {
            return 0;
        }
        return this.referenceCounts.decrementAndGet(index);
    }

    public boolean isVersionStale(int index, int version) {
        if (index < 0 || index >= this.capacity) {
            return true;
        }
        return version < this.rebuildVersions.get(index);
    }

    public int scheduleForGeneration(int index) {
        int currentState;
        if (index < 0 || index >= this.capacity) {
            return -1;
        }
        do {
            if ((currentState = this.states.get(index)) != 5 && currentState != 1 && currentState != 2) continue;
            return -1;
        } while (!this.states.compareAndSet(index, currentState, 1));
        return this.rebuildVersions.incrementAndGet(index);
    }

    public void setShape(int index, ShapeRefC shape) {
        if (index < 0 || index >= this.capacity) {
            if (shape != null) {
                shape.close();
            }
            return;
        }
        ShapeRefC oldShape = this.shapeRefs.getAndSet(index, shape);
        if (oldShape != null && oldShape != shape) {
            oldShape.close();
        }
    }

    @Nullable
    public Integer getIndexForPos(VxSectionPos pos) {
        return this.posToIndex.get(pos);
    }

    @Nullable
    public VxSectionPos getPosForIndex(int index) {
        if (index < 0 || index >= this.capacity) {
            return null;
        }
        return this.indexToPos.get(index);
    }

    public Set<VxSectionPos> getManagedPositions() {
        return new HashSet<VxSectionPos>(this.posToIndex.keySet());
    }

    public Collection<Integer> getActiveIndices() {
        return new ArrayList<Integer>(this.posToIndex.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getBodyIds() {
        Object object = this.allocationLock;
        synchronized (object) {
            int currentCount = this.count;
            int[] bodyIdsCopy = new int[currentCount];
            for (int i = 0; i < currentCount; ++i) {
                if (i >= this.bodyIds.length()) continue;
                bodyIdsCopy[i] = this.bodyIds.get(i);
            }
            return bodyIdsCopy;
        }
    }

    public int getChunkCount() {
        return this.posToIndex.size();
    }

    public int getCapacity() {
        return this.capacity;
    }

    private void resetIndex(int index) {
        this.states.set(index, 0);
        this.bodyIds.set(index, 0);
        this.shapeRefs.set(index, null);
        this.isPlaceholder.set(index, 1);
        this.rebuildVersions.set(index, 0);
        this.referenceCounts.set(index, 0);
    }

    private static AtomicIntegerArray growAtomic(AtomicIntegerArray oldArray, int newCapacity) {
        return VxChunkDataStore.growAtomic(oldArray, newCapacity, 0);
    }

    private static AtomicIntegerArray growAtomic(AtomicIntegerArray oldArray, int newCapacity, int defaultValue) {
        int i;
        AtomicIntegerArray newArray = new AtomicIntegerArray(newCapacity);
        if (oldArray != null) {
            int copyLength = Math.min(oldArray.length(), newCapacity);
            for (int i2 = 0; i2 < copyLength; ++i2) {
                newArray.set(i2, oldArray.get(i2));
            }
        }
        int n = i = oldArray != null ? oldArray.length() : 0;
        while (i < newCapacity) {
            newArray.set(i, defaultValue);
            ++i;
        }
        return newArray;
    }

    private static <T> AtomicReferenceArray<T> growAtomic(AtomicReferenceArray<T> oldArray, int newCapacity) {
        AtomicReferenceArray<T> newArray = new AtomicReferenceArray<T>(newCapacity);
        if (oldArray != null) {
            int copyLength = Math.min(oldArray.length(), newCapacity);
            for (int i = 0; i < copyLength; ++i) {
                newArray.set(i, oldArray.get(i));
            }
        }
        return newArray;
    }
}

