/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.vehicle;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.VehicleCollisionTester;
import com.github.stephengold.joltjni.VehicleCollisionTesterCastCylinder;
import com.github.stephengold.joltjni.VehicleConstraint;
import com.github.stephengold.joltjni.VehicleConstraintSettings;
import com.github.stephengold.joltjni.Wheel;
import com.github.stephengold.joltjni.WheelSettingsWv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.body.client.VxClientBodyDataStore;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;
import net.xmx.velthoric.physics.body.client.VxRenderState;
import net.xmx.velthoric.physics.body.manager.VxBodyDataStore;
import net.xmx.velthoric.physics.body.manager.VxJoltBridge;
import net.xmx.velthoric.physics.body.manager.VxRemovalReason;
import net.xmx.velthoric.physics.body.registry.VxBodyType;
import net.xmx.velthoric.physics.body.sync.VxDataAccessor;
import net.xmx.velthoric.physics.body.sync.VxDataSerializers;
import net.xmx.velthoric.physics.body.sync.VxSynchronizedData;
import net.xmx.velthoric.physics.body.type.VxRigidBody;
import net.xmx.velthoric.physics.mounting.VxMountable;
import net.xmx.velthoric.physics.vehicle.wheel.VxWheel;
import net.xmx.velthoric.physics.vehicle.wheel.VxWheelRenderState;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public abstract class VxVehicle
extends VxRigidBody
implements VxMountable {
    public static final VxDataAccessor<List<WheelSettingsWv>> DATA_WHEELS_SETTINGS = VxDataAccessor.create(VxVehicle.class, VxDataSerializers.WHEEL_SETTINGS_LIST);
    protected List<VxWheel> wheels = Collections.emptyList();
    protected VehicleConstraintSettings constraintSettings;
    protected VehicleCollisionTester collisionTester;
    protected VehicleConstraint constraint;
    private boolean vehicleStateDirty = false;
    protected float speedKmh = 0.0f;
    @OnlyIn(value=Dist.CLIENT)
    private VxWheelRenderState[] prevWheelStates;
    @OnlyIn(value=Dist.CLIENT)
    private VxWheelRenderState[] targetWheelStates;
    @OnlyIn(value=Dist.CLIENT)
    protected List<VxWheelRenderState> interpolatedWheelStates;

    protected VxVehicle(VxBodyType<? extends VxVehicle> type, VxPhysicsWorld world, UUID id) {
        super((VxBodyType<? extends VxRigidBody>)type, world, id);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected VxVehicle(VxBodyType<? extends VxVehicle> type, UUID id) {
        super((VxBodyType<? extends VxRigidBody>)type, id);
        this.prevWheelStates = new VxWheelRenderState[0];
        this.targetWheelStates = new VxWheelRenderState[0];
        this.interpolatedWheelStates = new ArrayList<VxWheelRenderState>();
    }

    @Override
    protected void defineSyncData(VxSynchronizedData.Builder builder) {
        builder.define(DATA_WHEELS_SETTINGS, Collections.emptyList());
    }

    @Override
    public void onBodyAdded(VxPhysicsWorld world) {
        super.onBodyAdded(world);
        Body body = VxJoltBridge.INSTANCE.getJoltBody(world, this.getBodyId());
        if (body == null || this.constraintSettings == null) {
            throw new IllegalStateException("Vehicle cannot be initialized without a body or constraint settings.");
        }
        this.constraint = new VehicleConstraint(body, this.constraintSettings);
        if (this.collisionTester == null) {
            this.collisionTester = new VehicleCollisionTesterCastCylinder(body.getObjectLayer());
        }
        this.constraint.setVehicleCollisionTester(this.collisionTester);
        world.getPhysicsSystem().addConstraint(this.constraint);
        world.getPhysicsSystem().addStepListener(this.constraint.getStepListener());
    }

    @Override
    public void onBodyRemoved(VxPhysicsWorld world, VxRemovalReason reason) {
        super.onBodyRemoved(world, reason);
        if (this.constraint != null) {
            world.getPhysicsSystem().removeStepListener(this.constraint.getStepListener());
            world.getPhysicsSystem().removeConstraint(this.constraint);
            this.constraint.close();
            this.constraint = null;
        }
        if (this.collisionTester != null) {
            this.collisionTester.close();
            this.collisionTester = null;
        }
    }

    @Override
    public void physicsTick(VxPhysicsWorld world) {
        super.physicsTick(world);
        if (this.constraint != null) {
            int index = this.getDataStoreIndex();
            if (index == -1) {
                return;
            }
            VxBodyDataStore dataStore = this.physicsWorld.getBodyManager().getDataStore();
            float vx = dataStore.velX[index];
            float vy = dataStore.velY[index];
            float vz = dataStore.velZ[index];
            float speedMs = (float)Math.sqrt(vx * vx + vy * vy + vz * vz);
            this.speedKmh = speedMs * 3.6f;
            if (!this.wheels.isEmpty()) {
                this.updateWheelStates();
            }
            if (dataStore.isActive[index]) {
                this.markVehicleStateDirty();
            }
        }
    }

    private void updateWheelStates() {
        for (int i = 0; i < this.wheels.size(); ++i) {
            VxWheel vxWheel = this.wheels.get(i);
            Wheel joltWheel = this.constraint.getWheel(i);
            vxWheel.setRotationAngle(joltWheel.getRotationAngle());
            vxWheel.setSteerAngle(joltWheel.getSteerAngle());
            vxWheel.setSuspensionLength(joltWheel.getSuspensionLength());
            vxWheel.setHasContact(joltWheel.hasContact());
        }
    }

    @Override
    public void writePersistenceData(VxByteBuf buf) {
        DATA_WHEELS_SETTINGS.getSerializer().write(buf, this.getSyncData(DATA_WHEELS_SETTINGS));
    }

    @Override
    public void readPersistenceData(VxByteBuf buf) {
        List<WheelSettingsWv> newSettings = DATA_WHEELS_SETTINGS.getSerializer().read(buf);
        if (newSettings.size() == this.wheels.size()) {
            ArrayList<WheelSettingsWv> wheelSettingsList = new ArrayList<WheelSettingsWv>(this.wheels.size());
            for (int i = 0; i < this.wheels.size(); ++i) {
                WheelSettingsWv settings = newSettings.get(i);
                this.wheels.get(i).setSettings(settings);
                wheelSettingsList.add(settings);
            }
            this.setSyncData(DATA_WHEELS_SETTINGS, wheelSettingsList);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateVehicleState(float speedKmh) {
        this.speedKmh = speedKmh;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateWheelState(int wheelIndex, float rotation, float steer, float suspension) {
        if (wheelIndex < 0 || wheelIndex >= this.targetWheelStates.length) {
            return;
        }
        this.prevWheelStates[wheelIndex] = this.targetWheelStates[wheelIndex];
        this.targetWheelStates[wheelIndex] = new VxWheelRenderState(rotation, steer, suspension);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void calculateRenderState(float partialTicks, VxRenderState outState, RVec3 tempPos, Quat tempRot) {
        super.calculateRenderState(partialTicks, outState, tempPos, tempRot);
        List<WheelSettingsWv> currentWheelSettings = this.getWheelSettings();
        int wheelCount = currentWheelSettings.size();
        if (wheelCount != this.targetWheelStates.length) {
            this.prevWheelStates = new VxWheelRenderState[wheelCount];
            this.targetWheelStates = new VxWheelRenderState[wheelCount];
            this.interpolatedWheelStates.clear();
            VxWheelRenderState initial = new VxWheelRenderState(0.0f, 0.0f, 0.0f);
            for (int i = 0; i < wheelCount; ++i) {
                this.prevWheelStates[i] = initial;
                this.targetWheelStates[i] = initial;
                this.interpolatedWheelStates.add(initial);
            }
        }
        int dataIndex = this.getDataStoreIndex();
        boolean isJustActivated = false;
        boolean isBodyActive = false;
        if (dataIndex != -1) {
            VxClientBodyDataStore store = VxClientBodyManager.getInstance().getStore();
            isBodyActive = store.state1_isActive[dataIndex];
            boolean wasBodyActive = store.state0_isActive[dataIndex];
            if (isBodyActive && !wasBodyActive) {
                isJustActivated = true;
            }
        }
        if (this.targetWheelStates.length > 0) {
            for (int i = 0; i < this.targetWheelStates.length; ++i) {
                VxWheelRenderState prev = this.prevWheelStates[i];
                VxWheelRenderState target = this.targetWheelStates[i];
                if (prev == null || target == null) continue;
                float alpha = isJustActivated ? 1.0f : (!isBodyActive ? 1.0f : partialTicks);
                float rot = Mth.m_14179_((float)alpha, (float)prev.rotationAngle(), (float)target.rotationAngle());
                float steer = Mth.m_14179_((float)alpha, (float)prev.steerAngle(), (float)target.steerAngle());
                float susp = Mth.m_14179_((float)alpha, (float)prev.suspensionLength(), (float)target.suspensionLength());
                this.interpolatedWheelStates.set(i, new VxWheelRenderState(rot, steer, susp));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<WheelSettingsWv> getWheelSettings() {
        return this.getSyncData(DATA_WHEELS_SETTINGS);
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<VxWheelRenderState> getInterpolatedWheelStates() {
        return this.interpolatedWheelStates;
    }

    public void markVehicleStateDirty() {
        this.vehicleStateDirty = true;
    }

    public boolean isVehicleStateDirty() {
        return this.vehicleStateDirty;
    }

    public void clearVehicleStateDirty() {
        this.vehicleStateDirty = false;
    }

    public float getSpeedKmh() {
        return this.speedKmh;
    }

    public List<VxWheel> getWheels() {
        return this.wheels;
    }
}

