/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.BodyLockMultiBase;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.readonly.ConstBodyLockInterface;

public class BodyLockMultiWrite
extends BodyLockMultiBase {
    private final ConstBodyLockInterface bli;

    public BodyLockMultiWrite(ConstBodyLockInterface bli, int ... bodyIds) {
        assert (bodyIds.length > 0) : bodyIds.length;
        this.bli = bli;
        long interfaceVa = bli.targetVa();
        long lockVa = BodyLockMultiWrite.create(interfaceVa, bodyIds);
        Runnable freeingAction = () -> BodyLockMultiWrite.free(lockVa);
        this.setVirtualAddress(lockVa, freeingAction);
    }

    public Body[] getBodies() {
        long lockVa = this.va();
        int numRequested = BodyLockMultiWrite.getNumBodies(lockVa);
        Body[] result = new Body[numRequested];
        PhysicsSystem system = this.bli.getSystem();
        for (int index = 0; index < numRequested; ++index) {
            long bodyVa = BodyLockMultiWrite.getBody(lockVa, index);
            result[index] = bodyVa == 0L ? null : new Body(system, bodyVa);
        }
        return result;
    }

    @Override
    public Body getBody(int index) {
        Body result;
        assert (index >= 0) : index;
        long lockVa = this.va();
        long bodyVa = BodyLockMultiWrite.getBody(lockVa, index);
        if (bodyVa == 0L) {
            result = null;
        } else {
            PhysicsSystem system = this.bli.getSystem();
            result = new Body(system, bodyVa);
        }
        return result;
    }

    @Override
    public int getNumBodies() {
        long lockVa = this.va();
        int result = BodyLockMultiWrite.getNumBodies(lockVa);
        return result;
    }

    @Override
    public void releaseLocks() {
        long lockVa = this.va();
        BodyLockMultiWrite.releaseLocks(lockVa);
    }

    private static native long create(long var0, int[] var2);

    private static native void free(long var0);

    private static native long getBody(long var0, int var2);

    private static native int getNumBodies(long var0);

    private static native void releaseLocks(long var0);
}

