/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.BodyManagerDrawSettings;
import com.github.stephengold.joltjni.BodyVector;
import com.github.stephengold.joltjni.DebugRenderer;
import com.github.stephengold.joltjni.NonCopyable;
import com.github.stephengold.joltjni.readonly.ConstBodyCreationSettings;
import com.github.stephengold.joltjni.readonly.ConstBroadPhaseLayerInterface;
import com.github.stephengold.joltjni.readonly.ConstPhysicsSettings;

public class BodyManager
extends NonCopyable {
    private ConstBroadPhaseLayerInterface layerMap;

    public BodyManager() {
        long managerVa = BodyManager.createDefault();
        this.setVirtualAddress(managerVa, () -> BodyManager.free(managerVa));
    }

    public void activateBodies(int ... idArray) {
        long managerVa = this.va();
        BodyManager.activateBodies(managerVa, idArray);
    }

    public boolean addBody(Body body) {
        long managerVa = this.va();
        long bodyVa = body.va();
        boolean result = BodyManager.addBody(managerVa, bodyVa);
        return result;
    }

    public Body allocateBody(ConstBodyCreationSettings settings) {
        long managerVa = this.va();
        long settingsVa = settings.targetVa();
        long bodyVa = BodyManager.allocateBody(managerVa, settingsVa);
        Body result = new Body(this, bodyVa);
        return result;
    }

    public void deactivateBodies(int ... idArray) {
        long managerVa = this.va();
        BodyManager.deactivateBodies(managerVa, idArray);
    }

    public void destroyBodies(int ... idArray) {
        long managerVa = this.va();
        BodyManager.destroyBodies(managerVa, idArray);
    }

    public void draw(BodyManagerDrawSettings drawSettings, ConstPhysicsSettings physicsSettings, DebugRenderer renderer) {
        long managerVa = this.va();
        long drawSettingsVa = drawSettings.va();
        long physicsSettingsVa = physicsSettings.targetVa();
        long rendererVa = renderer.va();
        BodyManager.draw(managerVa, drawSettingsVa, physicsSettingsVa, rendererVa);
    }

    public BodyVector getBodies() {
        long managerVa = this.va();
        long vectorVa = BodyManager.getBodies(managerVa);
        BodyVector result = new BodyVector(this, vectorVa);
        return result;
    }

    public Body getBody(int bodyId) {
        long managerVa = this.va();
        long resultVa = BodyManager.getBody(managerVa, bodyId);
        Body result = new Body(this, resultVa);
        return result;
    }

    public ConstBroadPhaseLayerInterface getBroadPhaseLayerInterface() {
        return this.layerMap;
    }

    public int getMaxBodies() {
        long managerVa = this.va();
        int result = BodyManager.getMaxBodies(managerVa);
        return result;
    }

    public void init(int maxBodies, int numBodyMutexes, ConstBroadPhaseLayerInterface map) {
        this.layerMap = map;
        long managerVa = this.va();
        long mapVa = map.targetVa();
        BodyManager.init(managerVa, maxBodies, numBodyMutexes, mapVa);
    }

    private static native void activateBodies(long var0, int[] var2);

    private static native boolean addBody(long var0, long var2);

    private static native long allocateBody(long var0, long var2);

    private static native long createDefault();

    private static native void deactivateBodies(long var0, int[] var2);

    private static native void destroyBodies(long var0, int[] var2);

    private static native void draw(long var0, long var2, long var4, long var6);

    private static native void free(long var0);

    private static native long getBodies(long var0);

    private static native long getBody(long var0, int var2);

    private static native int getMaxBodies(long var0);

    private static native void init(long var0, int var2, int var3, long var4);
}

