/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.GroupFilter;
import com.github.stephengold.joltjni.GroupFilterTableRef;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.readonly.ConstCollisionGroup;
import com.github.stephengold.joltjni.readonly.ConstGroupFilter;

public class CollisionGroup
extends JoltPhysicsObject
implements ConstCollisionGroup {
    public static final int cInvalidGroup = -1;
    public static final int cInvalidSubGroup = -1;

    public CollisionGroup() {
        long groupVa = CollisionGroup.createDefault();
        this.setVirtualAddress(groupVa, () -> CollisionGroup.free(groupVa));
    }

    CollisionGroup(JoltPhysicsObject container, long groupVa) {
        super(container, groupVa);
    }

    public CollisionGroup(GroupFilter filter, int groupId, int subGroupId) {
        long filterVa = filter.va();
        long groupVa = CollisionGroup.createGroup(filterVa, groupId, subGroupId);
        this.setVirtualAddress(groupVa, () -> CollisionGroup.free(groupVa));
    }

    public CollisionGroup(GroupFilterTableRef filterRef, int groupId, int subGroupId) {
        long filterVa = filterRef.targetVa();
        long groupVa = CollisionGroup.createGroup(filterVa, groupId, subGroupId);
        this.setVirtualAddress(groupVa, () -> CollisionGroup.free(groupVa));
    }

    public void setGroupFilter(GroupFilter filter) {
        long groupVa = this.va();
        long filterVa = filter.va();
        CollisionGroup.setGroupFilter(groupVa, filterVa);
    }

    public void setGroupId(int id) {
        long groupVa = this.va();
        CollisionGroup.setGroupId(groupVa, id);
    }

    public void setSubGroupId(int id) {
        long groupVa = this.va();
        CollisionGroup.setSubGroupId(groupVa, id);
    }

    @Override
    public ConstGroupFilter getGroupFilter() {
        long groupVa = this.va();
        long filterVa = CollisionGroup.getGroupFilter(groupVa);
        GroupFilter result = GroupFilter.newFilter(filterVa);
        return result;
    }

    @Override
    public int getGroupId() {
        long groupVa = this.va();
        int result = CollisionGroup.getGroupId(groupVa);
        return result;
    }

    @Override
    public int getSubGroupId() {
        long groupVa = this.va();
        int result = CollisionGroup.getSubGroupId(groupVa);
        return result;
    }

    private static native long createDefault();

    private static native long createGroup(long var0, int var2, int var3);

    private static native void free(long var0);

    private static native long getGroupFilter(long var0);

    private static native int getGroupId(long var0);

    private static native int getSubGroupId(long var0);

    private static native void setGroupFilter(long var0, long var2);

    private static native void setGroupId(long var0, int var2);

    private static native void setSubGroupId(long var0, int var2);
}

