/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.ConstraintRef;
import com.github.stephengold.joltjni.template.Array;

public class Constraints
extends Array<ConstraintRef> {
    Constraints(long arrayVa, boolean owner) {
        Runnable freeingAction = owner ? () -> Constraints.free(arrayVa) : null;
        this.setVirtualAddress(arrayVa, freeingAction);
    }

    @Override
    public int capacity() {
        long arrayVa = this.va();
        int result = Constraints.capacity(arrayVa);
        return result;
    }

    @Override
    public void erase(int startIndex, int stopIndex) {
        long vectorVa = this.va();
        Constraints.erase(vectorVa, startIndex, stopIndex);
    }

    @Override
    public ConstraintRef get(int elementIndex) {
        long arrayVa = this.va();
        long refVa = Constraints.get(arrayVa, elementIndex);
        ConstraintRef result = new ConstraintRef(refVa, true);
        return result;
    }

    @Override
    public void resize(int numReferences) {
        long arrayVa = this.va();
        Constraints.resize(arrayVa, numReferences);
    }

    @Override
    public void set(int elementIndex, ConstraintRef reference) {
        long arrayVa = this.va();
        long refVa = reference.va();
        Constraints.setRef(arrayVa, elementIndex, refVa);
    }

    @Override
    public int size() {
        long arrayVa = this.va();
        int result = Constraints.size(arrayVa);
        return result;
    }

    private static native int capacity(long var0);

    private static native void free(long var0);

    private static native void erase(long var0, int var2, int var3);

    private static native long get(long var0, int var2);

    private static native void resize(long var0, int var2);

    private static native void setRef(long var0, int var2, long var3);

    private static native int size(long var0);
}

