/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.IndexedTriangle;
import com.github.stephengold.joltjni.template.Array;

public final class IndexedTriangleList
extends Array<IndexedTriangle> {
    public IndexedTriangleList() {
        long listVa = IndexedTriangleList.createDefault();
        this.setVirtualAddress(listVa, () -> IndexedTriangleList.free(listVa));
    }

    @Override
    public int capacity() {
        long listVa = this.va();
        int result = IndexedTriangleList.capacity(listVa);
        return result;
    }

    @Override
    public void erase(int startIndex, int stopIndex) {
        long vectorVa = this.va();
        IndexedTriangleList.erase(vectorVa, startIndex, stopIndex);
    }

    @Override
    public IndexedTriangle get(int elementIndex) {
        long listVa = this.va();
        long triangleVa = IndexedTriangleList.getTriangle(listVa, elementIndex);
        IndexedTriangle result = new IndexedTriangle(this, triangleVa);
        return result;
    }

    @Override
    public void resize(int numTriangles) {
        long listVa = this.va();
        IndexedTriangleList.resize(listVa, numTriangles);
    }

    @Override
    public void set(int elementIndex, IndexedTriangle triangle) {
        long listVa = this.va();
        long triangleVa = triangle.va();
        IndexedTriangleList.setTriangle(listVa, elementIndex, triangleVa);
    }

    @Override
    public int size() {
        long listVa = this.va();
        int result = IndexedTriangleList.size(listVa);
        return result;
    }

    private static native int capacity(long var0);

    private static native long createDefault();

    private static native void erase(long var0, int var2, int var3);

    private static native void free(long var0);

    private static native long getTriangle(long var0, int var2);

    private static native void resize(long var0, int var2);

    private static native void setTriangle(long var0, int var2, long var3);

    private static native int size(long var0);
}

