/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.CollideShapeCollector;
import com.github.stephengold.joltjni.CollideShapeSettings;
import com.github.stephengold.joltjni.NonCopyable;
import com.github.stephengold.joltjni.ShapeFilter;
import com.github.stephengold.joltjni.readonly.ConstBody;
import com.github.stephengold.joltjni.readonly.Mat44Arg;

public class SimCollideBodyVsBody
extends NonCopyable {
    public SimCollideBodyVsBody() {
        long colliderVa = SimCollideBodyVsBody.createDefault();
        this.setVirtualAddressAsOwner(colliderVa);
    }

    public void collide(ConstBody body1, ConstBody body2, Mat44Arg comTransform1, Mat44Arg comTransform2, CollideShapeSettings settings, CollideShapeCollector collector, ShapeFilter filter) {
        long colliderVa = this.va();
        long body1Va = body1.targetVa();
        long body2Va = body2.targetVa();
        long comTransform1Va = comTransform1.targetVa();
        long comTransform2Va = comTransform2.targetVa();
        long settingsVa = settings.va();
        long collectorVa = collector.va();
        long filterVa = filter.va();
        SimCollideBodyVsBody.collide(colliderVa, body1Va, body2Va, comTransform1Va, comTransform2Va, settingsVa, collectorVa, filterVa);
    }

    final void setVirtualAddressAsOwner(long colliderVa) {
        Runnable freeingAction = () -> SimCollideBodyVsBody.free(colliderVa);
        this.setVirtualAddress(colliderVa, freeingAction);
    }

    private static native void collide(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    private static native long createDefault();

    private static native void free(long var0);
}

