/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.ConvexShapeSettings;
import com.github.stephengold.joltjni.PhysicsMaterial;
import com.github.stephengold.joltjni.enumerate.EShapeSubType;

public class TaperedCapsuleShapeSettings
extends ConvexShapeSettings {
    public TaperedCapsuleShapeSettings() {
        long settingsVa = TaperedCapsuleShapeSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.TaperedCapsule);
    }

    TaperedCapsuleShapeSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.TaperedCapsule);
    }

    public TaperedCapsuleShapeSettings(float halfHeight, float topRadius, float bottomRadius) {
        this(halfHeight, topRadius, bottomRadius, null);
    }

    public TaperedCapsuleShapeSettings(float halfHeight, float topRadius, float bottomRadius, PhysicsMaterial material) {
        long materialVa = material == null ? 0L : material.va();
        long settingsVa = TaperedCapsuleShapeSettings.createShapeSettings(halfHeight, topRadius, bottomRadius, materialVa);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.TaperedCapsule);
    }

    public TaperedCapsuleShapeSettings(TaperedCapsuleShapeSettings original) {
        long originalVa = original.va();
        long copyVa = TaperedCapsuleShapeSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EShapeSubType.TaperedCapsule);
    }

    public float getBottomRadius() {
        long settingsVa = this.va();
        float result = TaperedCapsuleShapeSettings.getBottomRadius(settingsVa);
        return result;
    }

    public float getHalfHeightOfTaperedCylinder() {
        long settingsVa = this.va();
        float result = TaperedCapsuleShapeSettings.getHalfHeightOfTaperedCylinder(settingsVa);
        return result;
    }

    public float getTopRadius() {
        long settingsVa = this.va();
        float result = TaperedCapsuleShapeSettings.getTopRadius(settingsVa);
        return result;
    }

    public void setBottomRadius(float radius) {
        long settingsVa = this.va();
        TaperedCapsuleShapeSettings.setBottomRadius(settingsVa, radius);
    }

    public void setHalfHeightOfTaperedCylinder(float halfHeight) {
        long settingsVa = this.va();
        TaperedCapsuleShapeSettings.setHalfHeightOfTaperedCylinder(settingsVa, halfHeight);
    }

    public void setTopRadius(float radius) {
        long settingsVa = this.va();
        TaperedCapsuleShapeSettings.setTopRadius(settingsVa, radius);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native long createShapeSettings(float var0, float var1, float var2, long var3);

    private static native float getBottomRadius(long var0);

    private static native float getHalfHeightOfTaperedCylinder(long var0);

    private static native float getTopRadius(long var0);

    private static native void setBottomRadius(long var0, float var2);

    private static native void setHalfHeightOfTaperedCylinder(long var0, float var2);

    private static native void setTopRadius(long var0, float var2);
}

