/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Jolt;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.VehicleCollisionTester;
import com.github.stephengold.joltjni.VehicleCollisionTesterCastSphereRef;
import com.github.stephengold.joltjni.readonly.Vec3Arg;

public class VehicleCollisionTesterCastSphere
extends VehicleCollisionTester {
    public VehicleCollisionTesterCastSphere(int objectLayer, float radius) {
        this(objectLayer, radius, Vec3.sAxisY());
    }

    public VehicleCollisionTesterCastSphere(int objectLayer, float radius, Vec3Arg up) {
        this(objectLayer, radius, up, Jolt.degreesToRadians(80.0f));
    }

    public VehicleCollisionTesterCastSphere(int objectLayer, float radius, Vec3Arg up, float maxSlopeAngle) {
        float upX = up.getX();
        float upY = up.getY();
        float upZ = up.getZ();
        long testerVa = VehicleCollisionTesterCastSphere.createTester(objectLayer, radius, upX, upY, upZ, maxSlopeAngle);
        this.setVirtualAddressAsCoOwner(testerVa);
    }

    VehicleCollisionTesterCastSphere(long testerVa) {
        this.setVirtualAddressAsCoOwner(testerVa);
    }

    @Override
    public VehicleCollisionTesterCastSphereRef toRef() {
        long testerVa = this.va();
        long refVa = VehicleCollisionTester.toRef(testerVa);
        VehicleCollisionTesterCastSphereRef result = new VehicleCollisionTesterCastSphereRef(refVa, true);
        return result;
    }

    private static native long createTester(int var0, float var1, float var2, float var3, float var4, float var5);
}

