/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;

public class VehicleEngineSettings
extends JoltPhysicsObject {
    public VehicleEngineSettings() {
        long settingsVa = VehicleEngineSettings.createDefault();
        this.setVirtualAddress(settingsVa, () -> VehicleEngineSettings.free(settingsVa));
    }

    VehicleEngineSettings(JoltPhysicsObject container, long settingsVa) {
        super(container, settingsVa);
    }

    public VehicleEngineSettings(VehicleEngineSettings original) {
        long originalVa = original.va();
        long copyVa = VehicleEngineSettings.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> VehicleEngineSettings.free(copyVa));
    }

    public float getAngularDamping() {
        long settingsVa = this.va();
        float result = VehicleEngineSettings.getAngularDamping(settingsVa);
        return result;
    }

    public float getInertia() {
        long settingsVa = this.va();
        float result = VehicleEngineSettings.getInertia(settingsVa);
        return result;
    }

    public float getMaxRpm() {
        long settingsVa = this.va();
        float result = VehicleEngineSettings.getMaxRpm(settingsVa);
        return result;
    }

    public float getMaxTorque() {
        long settingsVa = this.va();
        float result = VehicleEngineSettings.getMaxTorque(settingsVa);
        return result;
    }

    public float getMinRpm() {
        long settingsVa = this.va();
        float result = VehicleEngineSettings.getMinRpm(settingsVa);
        return result;
    }

    public void setAngularDamping(float damping) {
        long settingsVa = this.va();
        VehicleEngineSettings.setAngularDamping(settingsVa, damping);
    }

    public void setInertia(float inertia) {
        long settingsVa = this.va();
        VehicleEngineSettings.setInertia(settingsVa, inertia);
    }

    public void setMaxRpm(float rpm) {
        long settingsVa = this.va();
        VehicleEngineSettings.setMaxRpm(settingsVa, rpm);
    }

    public void setMaxTorque(float torque) {
        long settingsVa = this.va();
        VehicleEngineSettings.setMaxTorque(settingsVa, torque);
    }

    public void setMinRpm(float rpm) {
        long settingsVa = this.va();
        VehicleEngineSettings.setMinRpm(settingsVa, rpm);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    private static native float getAngularDamping(long var0);

    private static native float getInertia(long var0);

    private static native float getMaxRpm(long var0);

    private static native float getMaxTorque(long var0);

    private static native float getMinRpm(long var0);

    private static native void setAngularDamping(long var0, float var2);

    private static native void setInertia(long var0, float var2);

    private static native void setMaxRpm(long var0, float var2);

    private static native void setMaxTorque(long var0, float var2);

    private static native void setMinRpm(long var0, float var2);
}

