/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;

public class VehicleTrackSettings
extends JoltPhysicsObject {
    public VehicleTrackSettings() {
        long settingsVa = VehicleTrackSettings.createDefault();
        this.setVirtualAddress(settingsVa, () -> VehicleTrackSettings.free(settingsVa));
    }

    VehicleTrackSettings(JoltPhysicsObject container, long settingsVa) {
        super(container, settingsVa);
    }

    public VehicleTrackSettings(VehicleTrackSettings original) {
        long originalVa = original.va();
        long copyVa = VehicleTrackSettings.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> VehicleTrackSettings.free(copyVa));
    }

    public void addWheel(int wheelIndex) {
        long settingsVa = this.va();
        VehicleTrackSettings.addWheel(settingsVa, wheelIndex);
    }

    public float getAngularDamping() {
        long settingsVa = this.va();
        float result = VehicleTrackSettings.getAngularDamping(settingsVa);
        return result;
    }

    public float getDifferentialRatio() {
        long settingsVa = this.va();
        float result = VehicleTrackSettings.getDifferentialRatio(settingsVa);
        return result;
    }

    public int getDrivenWheel() {
        long settingsVa = this.va();
        int result = VehicleTrackSettings.getDrivenWheel(settingsVa);
        return result;
    }

    public float getInertia() {
        long settingsVa = this.va();
        float result = VehicleTrackSettings.getInertia(settingsVa);
        return result;
    }

    public int getNumWheels() {
        long settingsVa = this.va();
        int result = VehicleTrackSettings.getNumWheels(settingsVa);
        return result;
    }

    public void setDrivenWheel(int wheelIndex) {
        long settingsVa = this.va();
        VehicleTrackSettings.setDrivenWheel(settingsVa, wheelIndex);
    }

    private static native void addWheel(long var0, int var2);

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    private static native float getAngularDamping(long var0);

    private static native float getDifferentialRatio(long var0);

    private static native int getDrivenWheel(long var0);

    private static native float getInertia(long var0);

    private static native int getNumWheels(long var0);

    private static native void setDrivenWheel(long var0, int var2);
}

