/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.enumerate.ELraType;
import com.github.stephengold.joltjni.readonly.ConstVertexAttributes;

public class VertexAttributes
extends JoltPhysicsObject
implements ConstVertexAttributes {
    public VertexAttributes() {
        long attributesVa = VertexAttributes.createDefault();
        this.setVirtualAddress(attributesVa, () -> VertexAttributes.free(attributesVa));
    }

    public VertexAttributes(float compliance, float shearCompliance, float bendCompliance) {
        this(compliance, shearCompliance, bendCompliance, ELraType.None);
    }

    public VertexAttributes(float compliance, float shearCompliance, float bendCompliance, ELraType lraType) {
        this(compliance, shearCompliance, bendCompliance, lraType, 1.0f);
    }

    public VertexAttributes(float compliance, float shearCompliance, float bendCompliance, ELraType lraType, float lraMultiplier) {
        int ordinal = lraType.ordinal();
        long attributesVa = VertexAttributes.createAttributes(compliance, shearCompliance, bendCompliance, ordinal, lraMultiplier);
        this.setVirtualAddress(attributesVa, () -> VertexAttributes.free(attributesVa));
    }

    public float setBendCompliance(float compliance) {
        long attributesVa = this.va();
        VertexAttributes.setBendCompliance(attributesVa, compliance);
        return compliance;
    }

    public float setCompliance(float compliance) {
        long attributesVa = this.va();
        VertexAttributes.setCompliance(attributesVa, compliance);
        return compliance;
    }

    public float setLraMaxDistanceMultiplier(float multiplier) {
        long attributesVa = this.va();
        VertexAttributes.setLraMaxDistanceMultiplier(attributesVa, multiplier);
        return multiplier;
    }

    public void setLraType(ELraType type) {
        long attributesVa = this.va();
        int ordinal = type.ordinal();
        VertexAttributes.setLraType(attributesVa, ordinal);
    }

    public float setShearCompliance(float compliance) {
        long attributesVa = this.va();
        VertexAttributes.setShearCompliance(attributesVa, compliance);
        return compliance;
    }

    @Override
    public float getBendCompliance() {
        long attributesVa = this.va();
        float result = VertexAttributes.getBendCompliance(attributesVa);
        return result;
    }

    @Override
    public float getCompliance() {
        long attributesVa = this.va();
        float result = VertexAttributes.getCompliance(attributesVa);
        return result;
    }

    @Override
    public float getLraMaxDistanceMultiplier() {
        long attributesVa = this.va();
        float result = VertexAttributes.getLraMaxDistanceMultiplier(attributesVa);
        return result;
    }

    @Override
    public ELraType getLraType() {
        long attributesVa = this.va();
        int ordinal = VertexAttributes.getLraType(attributesVa);
        ELraType result = ELraType.values()[ordinal];
        return result;
    }

    @Override
    public float getShearCompliance() {
        long attributesVa = this.va();
        float result = VertexAttributes.getShearCompliance(attributesVa);
        return result;
    }

    private static native long createAttributes(float var0, float var1, float var2, int var3, float var4);

    private static native long createDefault();

    private static native void free(long var0);

    private static native float getBendCompliance(long var0);

    private static native float getCompliance(long var0);

    private static native float getLraMaxDistanceMultiplier(long var0);

    private static native int getLraType(long var0);

    private static native float getShearCompliance(long var0);

    private static native void setBendCompliance(long var0, float var2);

    private static native void setCompliance(long var0, float var2);

    private static native void setLraMaxDistanceMultiplier(long var0, float var2);

    private static native void setLraType(long var0, int var2);

    private static native void setShearCompliance(long var0, float var2);
}

