/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni.std;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.std.RandomNumberEngine;

public class Mt19937
extends JoltPhysicsObject
implements RandomNumberEngine {
    public Mt19937() {
        long generatorVa = Mt19937.createDefault();
        this.setVirtualAddress(generatorVa, () -> Mt19937.free(generatorVa));
    }

    public Mt19937(int seed) {
        long generatorVa = Mt19937.createSeeded(seed);
        this.setVirtualAddress(generatorVa, () -> Mt19937.free(generatorVa));
    }

    @Override
    public int nextInt() {
        long generatorVa = this.va();
        int result = Mt19937.nextInt(generatorVa);
        return result;
    }

    @Override
    public void seed(int value) {
        long generatorVa = this.va();
        Mt19937.setSeed(generatorVa, value);
    }

    private static native long createDefault();

    private static native long createSeeded(int var0);

    private static native void free(long var0);

    private static native int nextInt(long var0);

    private static native void setSeed(long var0, int var2);
}

