/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.drivable.motorcycle;

import com.github.stephengold.joltjni.BodyCreationSettings;
import com.github.stephengold.joltjni.BoxShapeSettings;
import com.github.stephengold.joltjni.MotorcycleControllerSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.VehicleCollisionTester;
import com.github.stephengold.joltjni.VehicleCollisionTesterCastCylinder;
import com.github.stephengold.joltjni.VehicleConstraintSettings;
import com.github.stephengold.joltjni.VehicleDifferentialSettings;
import com.github.stephengold.joltjni.VehicleEngineSettings;
import com.github.stephengold.joltjni.VehicleTransmissionSettings;
import com.github.stephengold.joltjni.WheelSettingsWv;
import com.github.stephengold.joltjni.enumerate.EMotionQuality;
import com.github.stephengold.joltjni.enumerate.EMotionType;
import com.github.stephengold.joltjni.enumerate.EOverrideMassProperties;
import com.github.stephengold.joltjni.enumerate.ETransmissionMode;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_238;
import net.xmx.velthoric.physics.body.registry.VxBodyType;
import net.xmx.velthoric.physics.body.type.factory.VxRigidBodyFactory;
import net.xmx.velthoric.physics.mounting.seat.VxSeat;
import net.xmx.velthoric.physics.vehicle.type.motorcycle.VxMotorcycle;
import net.xmx.velthoric.physics.vehicle.wheel.VxWheel;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.joml.Vector3f;

public class MotorcycleImpl
extends VxMotorcycle {
    public MotorcycleImpl(VxBodyType<MotorcycleImpl> type, VxPhysicsWorld world, UUID id) {
        super((VxBodyType<? extends VxMotorcycle>)type, world, id);
    }

    @Environment(value=EnvType.CLIENT)
    public MotorcycleImpl(VxBodyType<MotorcycleImpl> type, UUID id) {
        super((VxBodyType<? extends VxMotorcycle>)type, id);
    }

    @Override
    protected VehicleConstraintSettings createConstraintSettings() {
        this.wheels = new ArrayList(2);
        float wheelRadius = 0.4f;
        float wheelWidth = 0.15f;
        float wheelBase = 1.4f;
        float suspensionMinLength = 0.15f;
        float suspensionMaxLength = 0.4f;
        float suspensionFrequency = 5.0f;
        float suspensionDamping = 0.8f;
        WheelSettingsWv rearWheel = new WheelSettingsWv();
        rearWheel.setPosition(new Vec3(0.0f, 0.0f, -wheelBase * 0.5f));
        rearWheel.setRadius(wheelRadius);
        rearWheel.setWidth(wheelWidth);
        rearWheel.setSuspensionMinLength(suspensionMinLength);
        rearWheel.setSuspensionMaxLength(suspensionMaxLength);
        rearWheel.getSuspensionSpring().setFrequency(suspensionFrequency);
        rearWheel.getSuspensionSpring().setDamping(suspensionDamping);
        rearWheel.setMaxSteerAngle(0.0f);
        WheelSettingsWv frontWheel = new WheelSettingsWv();
        frontWheel.setPosition(new Vec3(0.0f, 0.0f, wheelBase * 0.5f));
        frontWheel.setRadius(wheelRadius);
        frontWheel.setWidth(wheelWidth);
        frontWheel.setSuspensionMinLength(suspensionMinLength);
        frontWheel.setSuspensionMaxLength(suspensionMaxLength);
        frontWheel.getSuspensionSpring().setFrequency(suspensionFrequency);
        frontWheel.getSuspensionSpring().setDamping(suspensionDamping);
        frontWheel.setMaxSteerAngle((float)Math.toRadians(40.0));
        this.wheels.add(new VxWheel(rearWheel));
        this.wheels.add(new VxWheel(frontWheel));
        this.setSyncData(DATA_WHEELS_SETTINGS, this.wheels.stream().map(VxWheel::getSettings).collect(Collectors.toList()));
        MotorcycleControllerSettings controllerSettings = new MotorcycleControllerSettings();
        VehicleEngineSettings engineSettings = controllerSettings.getEngine();
        engineSettings.setMaxTorque(800.0f);
        engineSettings.setMaxRpm(12000.0f);
        engineSettings.setMinRpm(1000.0f);
        VehicleTransmissionSettings transmissionSettings = controllerSettings.getTransmission();
        transmissionSettings.setMode(ETransmissionMode.Auto);
        transmissionSettings.setGearRatios(2.9f, 2.1f, 1.6f, 1.3f, 1.1f);
        transmissionSettings.setReverseGearRatios(-2.5f);
        transmissionSettings.setShiftUpRpm(8000.0f);
        transmissionSettings.setShiftDownRpm(3000.0f);
        controllerSettings.setNumDifferentials(1);
        VehicleDifferentialSettings differential = controllerSettings.getDifferential(0);
        differential.setLeftWheel(0);
        differential.setRightWheel(-1);
        differential.setDifferentialRatio(2.5f);
        VehicleConstraintSettings settings = new VehicleConstraintSettings();
        settings.addWheels(rearWheel, frontWheel);
        settings.setController(controllerSettings);
        return settings;
    }

    @Override
    protected VehicleCollisionTester createCollisionTester() {
        return new VehicleCollisionTesterCastCylinder(1);
    }

    @Override
    public List<VxSeat> defineSeats() {
        Vector3f riderOffset = new Vector3f(0.0f, 0.7f, -0.2f);
        class_238 localAABB = new class_238((double)riderOffset.x - 0.3, (double)riderOffset.y - 0.4, (double)riderOffset.z - 0.3, (double)riderOffset.x + 0.3, (double)riderOffset.y + 0.4, (double)riderOffset.z + 0.3);
        String seatIdentifier = "driver_seat";
        UUID seatId = UUID.nameUUIDFromBytes((this.getPhysicsId().toString() + seatIdentifier).getBytes(StandardCharsets.UTF_8));
        VxSeat driverSeat = new VxSeat(seatId, seatIdentifier, localAABB, riderOffset, true);
        return List.of(driverSeat);
    }

    @Override
    public int createJoltBody(VxRigidBodyFactory factory) {
        try (BoxShapeSettings shapeSettings = new BoxShapeSettings((Vec3Arg)this.getSyncData(DATA_CHASSIS_HALF_EXTENTS));){
            int n;
            try (BodyCreationSettings bcs = new BodyCreationSettings();){
                bcs.setShapeSettings(shapeSettings);
                bcs.setMotionType(EMotionType.Dynamic);
                bcs.setObjectLayer(1);
                bcs.setMotionQuality(EMotionQuality.LinearCast);
                bcs.getMassPropertiesOverride().setMass(250.0f);
                bcs.setOverrideMassProperties(EOverrideMassProperties.CalculateInertia);
                n = factory.create(shapeSettings, bcs);
            }
            return n;
        }
    }
}

