/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.command;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.enumerate.EActivation;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.body.registry.VxBodyRegistry;
import net.xmx.velthoric.physics.body.registry.VxBodyType;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class VxSummonCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"vxsummon").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"type", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> {
            VxBodyRegistry registry = VxBodyRegistry.getInstance();
            return class_2172.method_9264(registry.getRegisteredTypes().values().stream().filter(VxBodyType::isSummonable).map(type -> type.getTypeId().toString()), (SuggestionsBuilder)builder);
        }).then(class_2170.method_9244((String)"position", (ArgumentType)class_2277.method_9735((boolean)true)).executes(VxSummonCommand::execute))).executes(VxSummonCommand::execute)));
    }

    private static int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_243 pos;
        class_2168 source = (class_2168)context.getSource();
        class_3218 level = source.method_9225();
        try {
            pos = class_2277.method_9736(context, (String)"position");
        }
        catch (IllegalArgumentException e) {
            pos = source.method_9222();
        }
        class_2960 typeId = class_2232.method_9443(context, (String)"type");
        VxBodyType<?> type = VxBodyRegistry.getInstance().getRegistrationData(typeId);
        if (type == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("physics body type not found: " + String.valueOf(typeId))));
            return 0;
        }
        if (!type.isSummonable()) {
            source.method_9213((class_2561)class_2561.method_43470((String)("physics body type '" + String.valueOf(typeId) + "' cannot be summoned.")));
            return 0;
        }
        VxPhysicsWorld world = VxPhysicsWorld.get((class_5321<class_1937>)level.method_27983());
        if (world == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Physics system for this dimension is not initialized."));
            return 0;
        }
        VxBodyManager manager = world.getBodyManager();
        VxTransform transform = new VxTransform(new RVec3(pos.field_1352, pos.field_1351, pos.field_1350), Quat.sIdentity());
        Object body = type.create(world, UUID.randomUUID());
        if (body == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Failed to create an instance of " + String.valueOf(typeId))));
            return 0;
        }
        manager.addConstructedBody((VxBody)body, EActivation.Activate, transform);
        source.method_9226(() -> class_2561.method_43470((String)String.format("Successfully summoned physics body '%s' with ID: %s", typeId, body.getPhysicsId())), true);
        return 1;
    }
}

