/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.debug.screen;

import com.github.stephengold.joltjni.Jolt;
import dev.architectury.platform.Platform;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.xmx.velthoric.event.api.VxDebugEvent;
import net.xmx.velthoric.physics.body.client.VxClientBodyDataStore;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.body.type.VxRigidBody;
import net.xmx.velthoric.physics.body.type.VxSoftBody;

@Environment(value=EnvType.CLIENT)
public class DebugScreen {
    public static void registerEvents() {
        VxDebugEvent.AddDebugInfo.EVENT.register(DebugScreen::onDebugEvent);
    }

    public static void onDebugEvent(VxDebugEvent.AddDebugInfo event) {
        List<String> infoList = event.getInfoList();
        class_310 mc = class_310.method_1551();
        if (!mc.field_1690.field_1866 || mc.field_1687 == null) {
            return;
        }
        infoList.add("");
        infoList.add("Velthoric v" + DebugScreen.getModVersion());
        infoList.add("Jolt JNI v" + Jolt.versionString());
        DebugScreen.addClientInfo(infoList);
    }

    private static void addClientInfo(List<String> left) {
        VxClientBodyManager clientManager = VxClientBodyManager.getInstance();
        VxClientBodyDataStore store = clientManager.getStore();
        long clientRigidCount = 0L;
        long clientSoftCount = 0L;
        int totalVertexCount = 0;
        for (UUID id : store.getAllPhysicsIds()) {
            VxBody body;
            Integer index = store.getIndexForId(id);
            if (index == null || (body = clientManager.getBody(id)) == null) continue;
            if (body instanceof VxRigidBody) {
                ++clientRigidCount;
                continue;
            }
            if (!(body instanceof VxSoftBody)) continue;
            ++clientSoftCount;
            if (store.render_vertexData[index] == null) continue;
            totalVertexCount += store.render_vertexData[index].length / 3;
        }
        left.add("RB: " + clientRigidCount + " | SB: " + clientSoftCount);
        left.add(String.format("Vertices: %d", totalVertexCount));
    }

    private static String getModVersion() {
        return Platform.getMod((String)"velthoric").getVersion();
    }
}

