/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.physicsgun.manager;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.xmx.velthoric.item.physicsgun.packet.PhysicsGunActionPacket;
import net.xmx.velthoric.network.VxPacketHandler;

public class PhysicsGunClientManager {
    private static final PhysicsGunClientManager INSTANCE = new PhysicsGunClientManager();
    private final Map<UUID, ClientGrabData> activeGrabs = new ConcurrentHashMap<UUID, ClientGrabData>();
    private final Set<UUID> playersTryingToGrab = ConcurrentHashMap.newKeySet();
    private boolean rotationMode = false;

    private PhysicsGunClientManager() {
    }

    public static PhysicsGunClientManager getInstance() {
        return INSTANCE;
    }

    public void startGrabAttempt() {
        VxPacketHandler.sendToServer(new PhysicsGunActionPacket(PhysicsGunActionPacket.ActionType.START_GRAB_ATTEMPT));
    }

    public void stopGrabAttempt() {
        VxPacketHandler.sendToServer(new PhysicsGunActionPacket(PhysicsGunActionPacket.ActionType.STOP_GRAB_ATTEMPT));
        this.setRotationMode(false);
    }

    public void updateState(Map<UUID, ClientGrabData> newActiveGrabs, Set<UUID> newPlayersTryingToGrab) {
        this.activeGrabs.clear();
        this.activeGrabs.putAll(newActiveGrabs);
        this.playersTryingToGrab.clear();
        this.playersTryingToGrab.addAll(newPlayersTryingToGrab);
    }

    public boolean isGrabbing(class_1657 player) {
        return this.activeGrabs.containsKey(player.method_5667());
    }

    public boolean isTryingToGrab(class_1657 player) {
        return this.playersTryingToGrab.contains(player.method_5667());
    }

    public Map<UUID, ClientGrabData> getActiveGrabs() {
        return this.activeGrabs;
    }

    public Set<UUID> getPlayersTryingToGrab() {
        return this.playersTryingToGrab;
    }

    public boolean isRotationMode() {
        return this.rotationMode;
    }

    public void setRotationMode(boolean active) {
        this.rotationMode = active;
    }

    public record ClientGrabData(UUID objectUuid, class_243 localHitPoint) {
    }
}

