/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.mounting.render;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3966;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.xmx.velthoric.math.VxOBB;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.client.VxClientBodyDataStore;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.mounting.entity.VxMountingEntity;
import net.xmx.velthoric.physics.mounting.entity.VxMountingEntityState;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_757.class})
public abstract class MixinGameRenderer {
    @Shadow
    @Final
    class_310 field_4015;
    @Shadow
    @Final
    private class_4184 field_18765;
    @Unique
    private final RVec3 velthoric_interpolatedPosition = new RVec3();
    @Unique
    private final Quat velthoric_interpolatedRotation = new Quat();
    @Unique
    private final Map<Integer, VxMountingEntityState> velthoric_originalStates = new HashMap<Integer, VxMountingEntityState>();

    @Shadow
    protected abstract double method_3196(class_4184 var1, float var2, boolean var3);

    @Shadow
    public abstract Matrix4f method_22973(double var1);

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V", shift=At.Shift.BEFORE)})
    private void velthoric_preRenderLevel(float tickDelta, long startTime, boolean tick, CallbackInfo ci) {
        class_638 clientWorld = this.field_4015.field_1687;
        if (clientWorld == null) {
            return;
        }
        this.velthoric_originalStates.clear();
        for (class_1297 entity : clientWorld.method_18112()) {
            class_1297 passenger;
            VxMountingEntity proxy;
            if (!(entity instanceof VxMountingEntity) || (proxy = (VxMountingEntity)entity).method_5685().isEmpty() || (passenger = proxy.method_31483()) == null) continue;
            this.velthoric_adjustEntityForRender(proxy, tickDelta);
            this.velthoric_adjustEntityForRender(passenger, tickDelta);
        }
    }

    @Unique
    private void velthoric_adjustEntityForRender(class_1297 entity, float tickDelta) {
        VxMountingEntity proxy;
        class_1297 vehicle = entity.method_5854();
        if (vehicle instanceof VxMountingEntity) {
            VxMountingEntity vehicleProxy;
            proxy = vehicleProxy = (VxMountingEntity)vehicle;
        } else if (entity instanceof VxMountingEntity) {
            VxMountingEntity selfProxy;
            proxy = selfProxy = (VxMountingEntity)entity;
        } else {
            return;
        }
        proxy.getPhysicsBodyId().ifPresent(id -> {
            VxClientBodyManager manager = VxClientBodyManager.getInstance();
            VxClientBodyDataStore store = manager.getStore();
            Integer index = store.getIndexForId((UUID)id);
            if (index == null || !store.render_isInitialized[index]) {
                return;
            }
            this.velthoric_originalStates.computeIfAbsent(entity.method_5628(), k -> new VxMountingEntityState()).setFrom(entity);
            manager.getInterpolator().interpolateFrame(store, index, tickDelta, this.velthoric_interpolatedPosition, this.velthoric_interpolatedRotation);
            Quaternionf physRotation = new Quaternionf(this.velthoric_interpolatedRotation.getX(), this.velthoric_interpolatedRotation.getY(), this.velthoric_interpolatedRotation.getZ(), this.velthoric_interpolatedRotation.getW());
            Vector3f rideOffset = new Vector3f((Vector3fc)proxy.getMountPositionOffset());
            physRotation.transform(rideOffset);
            double targetX = this.velthoric_interpolatedPosition.xx() + (double)rideOffset.x;
            double targetY = this.velthoric_interpolatedPosition.yy() + (double)rideOffset.y;
            double targetZ = this.velthoric_interpolatedPosition.zz() + (double)rideOffset.z;
            entity.method_5814(targetX, targetY, targetZ);
            entity.field_6014 = targetX;
            entity.field_6036 = targetY;
            entity.field_5969 = targetZ;
            entity.field_6038 = targetX;
            entity.field_5971 = targetY;
            entity.field_5989 = targetZ;
        });
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V", shift=At.Shift.AFTER)})
    private void velthoric_postRenderLevel(float tickDelta, long startTime, boolean tick, CallbackInfo ci) {
        class_638 clientWorld = this.field_4015.field_1687;
        if (clientWorld == null) {
            return;
        }
        this.velthoric_originalStates.forEach((id, state) -> {
            class_1297 entity = clientWorld.method_8469(id.intValue());
            if (entity != null) {
                state.applyTo(entity);
            }
        });
        this.velthoric_originalStates.clear();
    }

    @WrapOperation(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;prepareCullFrustum(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/world/phys/Vec3;Lorg/joml/Matrix4f;)V")})
    private void velthoric_setupCameraWithPhysicsBody(class_761 instance, class_4587 poseStack, class_243 cameraPos, Matrix4f projectionMatrix, Operation<Void> original, float partialTicks, long finishTimeNano, class_4587 matrixStack) {
        class_1297 class_12972;
        class_746 player = this.field_4015.field_1724;
        if (player == null || !((class_12972 = player.method_5854()) instanceof VxMountingEntity)) {
            original.call(new Object[]{instance, matrixStack, cameraPos, projectionMatrix});
            return;
        }
        VxMountingEntity proxy = (VxMountingEntity)class_12972;
        proxy.getPhysicsBodyId().ifPresentOrElse(id -> {
            VxClientBodyManager manager = VxClientBodyManager.getInstance();
            VxClientBodyDataStore store = manager.getStore();
            Integer index = store.getIndexForId((UUID)id);
            if (index == null || !store.render_isInitialized[index]) {
                original.call(new Object[]{instance, matrixStack, cameraPos, projectionMatrix});
                return;
            }
            manager.getInterpolator().interpolateRotation(store, index, partialTicks, this.velthoric_interpolatedRotation);
            Quaternionf physRotation = new Quaternionf(this.velthoric_interpolatedRotation.getX(), this.velthoric_interpolatedRotation.getY(), this.velthoric_interpolatedRotation.getZ(), this.velthoric_interpolatedRotation.getW());
            Quaternionf invPhysRotation = new Quaternionf((Quaterniondc)new Quaterniond((Quaternionfc)physRotation).conjugate());
            matrixStack.method_22907(invPhysRotation);
            Matrix3f matrix3f = new Matrix3f((Matrix3fc)matrixStack.method_23760().method_23762());
            matrix3f.invert();
            RenderSystem.setInverseViewRotationMatrix((Matrix3f)matrix3f);
            double fov = this.method_3196(this.field_18765, partialTicks, true);
            Matrix4f newProjectionMatrix = this.method_22973(Math.max(fov, (double)((Integer)this.field_4015.field_1690.method_41808().method_41753()).intValue()));
            original.call(new Object[]{instance, matrixStack, this.field_18765.method_19326(), newProjectionMatrix});
        }, () -> original.call(new Object[]{instance, matrixStack, cameraPos, projectionMatrix}));
    }

    @WrapOperation(method={"pick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/ProjectileUtil;getEntityHitResult(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;D)Lnet/minecraft/world/phys/EntityHitResult;")})
    private class_3966 velthoric_pickEntityWithOBB(class_1297 shooter, class_243 start, class_243 end, class_238 searchBox, Predicate<class_1297> filter, double maxDistanceSq, Operation<class_3966> original) {
        Predicate<class_1297> vanillaFilter = filter.and(entity -> !(entity.method_5854() instanceof VxMountingEntity));
        class_3966 vanillaResult = (class_3966)original.call(new Object[]{shooter, start, end, searchBox, vanillaFilter, maxDistanceSq});
        double closestHitDistSq = vanillaResult != null ? start.method_1025(vanillaResult.method_17784()) : maxDistanceSq;
        class_3966 bestOverallResult = vanillaResult;
        List potentialTargets = this.field_4015.field_1687.method_8333(shooter, searchBox, filter);
        float partialTicks = this.field_4015.method_1488();
        for (class_1297 potentialTarget : potentialTargets) {
            double distSq;
            VxMountingEntity proxy;
            Optional physBodyOpt;
            class_1297 class_12972 = potentialTarget.method_5854();
            if (!(class_12972 instanceof VxMountingEntity) || !(physBodyOpt = (proxy = (VxMountingEntity)class_12972).getPhysicsBodyId().flatMap(id -> Optional.ofNullable(VxClientBodyManager.getInstance().getBody((UUID)id)))).isPresent() || !((VxBody)physBodyOpt.get()).isInitialized()) continue;
            VxBody physBody = (VxBody)physBodyOpt.get();
            VxTransform physTransform = this.velthoric_getPhysicsBodyTransform(physBody, partialTicks);
            Vector3f rideOffset = new Vector3f((Vector3fc)proxy.getMountPositionOffset());
            physTransform.getRotation(new Quaternionf()).transform(rideOffset);
            physTransform.getTranslation().addInPlace(rideOffset.x(), rideOffset.y(), rideOffset.z());
            class_238 targetAABB = potentialTarget.method_5829().method_1014((double)potentialTarget.method_5871());
            class_238 localEntityAABB = targetAABB.method_989(-potentialTarget.method_23317(), -potentialTarget.method_23318(), -potentialTarget.method_23321());
            VxOBB obb = new VxOBB(physTransform, localEntityAABB);
            Optional<class_243> hitPos = obb.clip(start, end);
            if (!hitPos.isPresent() || !((distSq = start.method_1025(hitPos.get())) < closestHitDistSq)) continue;
            closestHitDistSq = distSq;
            bestOverallResult = new class_3966(potentialTarget, hitPos.get());
        }
        return bestOverallResult;
    }

    @Unique
    private VxTransform velthoric_getPhysicsBodyTransform(VxBody clientBody, float partialTicks) {
        VxTransform transform = new VxTransform();
        VxClientBodyManager.getInstance().getInterpolator().interpolateFrame(VxClientBodyManager.getInstance().getStore(), clientBody.getDataStoreIndex(), partialTicks, this.velthoric_interpolatedPosition, this.velthoric_interpolatedRotation);
        transform.getTranslation().set(this.velthoric_interpolatedPosition);
        transform.getRotation().set(this.velthoric_interpolatedRotation);
        return transform;
    }
}

