/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.manager;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.BodyInterface;
import com.github.stephengold.joltjni.BodyLockRead;
import com.github.stephengold.joltjni.BodyLockWrite;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.ShapeRefC;
import com.github.stephengold.joltjni.ShapeResult;
import com.github.stephengold.joltjni.SoftBodyCreationSettings;
import com.github.stephengold.joltjni.SoftBodySharedSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EActivation;
import com.github.stephengold.joltjni.readonly.ConstBody;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.physics.body.manager.VxBodyDataStore;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.body.manager.VxRemovalReason;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.body.type.VxRigidBody;
import net.xmx.velthoric.physics.body.type.VxSoftBody;
import net.xmx.velthoric.physics.body.type.factory.VxRigidBodyFactory;
import net.xmx.velthoric.physics.body.type.factory.VxSoftBodyFactory;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.jetbrains.annotations.Nullable;

public enum VxJoltBridge {
    INSTANCE;


    @Nullable
    public Body getJoltBody(VxPhysicsWorld world, VxBody body) {
        if (body == null) {
            return null;
        }
        return this.getJoltBody(world, body.getBodyId());
    }

    @Nullable
    public ConstBody getConstJoltBody(VxPhysicsWorld world, VxBody body) {
        if (body == null) {
            return null;
        }
        return this.getConstJoltBody(world, body.getBodyId());
    }

    @Nullable
    public Body getJoltBody(VxPhysicsWorld world, int bodyId) {
        if (bodyId == 0) {
            return null;
        }
        try (BodyLockWrite lock = new BodyLockWrite(world.getPhysicsSystem().getBodyLockInterface(), bodyId);){
            if (lock.succeededAndIsInBroadPhase()) {
                Body body = lock.getBody();
                return body;
            }
        }
        return null;
    }

    @Nullable
    public ConstBody getConstJoltBody(VxPhysicsWorld world, int bodyId) {
        if (bodyId == 0) {
            return null;
        }
        try (BodyLockRead lock = new BodyLockRead(world.getPhysicsSystem().getBodyLockInterface(), bodyId);){
            if (lock.succeededAndIsInBroadPhase()) {
                ConstBody constBody = lock.getBody();
                return constBody;
            }
        }
        return null;
    }

    public void createAndAddJoltRigidBody(VxRigidBody body, VxBodyManager manager, @Nullable Vec3 linearVelocity, @Nullable Vec3 angularVelocity, EActivation activation) {
        try {
            VxPhysicsWorld world = manager.getPhysicsWorld();
            VxBodyDataStore dataStore = manager.getDataStore();
            VxRigidBodyFactory factory = (shapeSettings, bcs) -> {
                try (ShapeResult shapeResult = shapeSettings.create();){
                    int n;
                    block15: {
                        if (shapeResult.hasError()) {
                            throw new IllegalStateException("Shape creation failed: " + shapeResult.getError());
                        }
                        ShapeRefC shapeRef = shapeResult.get();
                        try {
                            int index = body.getDataStoreIndex();
                            bcs.setShape(shapeRef);
                            bcs.setPosition(dataStore.posX[index], dataStore.posY[index], dataStore.posZ[index]);
                            bcs.setRotation(new Quat(dataStore.rotX[index], dataStore.rotY[index], dataStore.rotZ[index], dataStore.rotW[index]));
                            if (linearVelocity != null) {
                                bcs.setLinearVelocity(linearVelocity);
                            }
                            if (angularVelocity != null) {
                                bcs.setAngularVelocity(angularVelocity);
                            }
                            n = world.getPhysicsSystem().getBodyInterface().createAndAddBody(bcs, activation);
                            if (shapeRef == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (shapeRef != null) {
                                try {
                                    shapeRef.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        shapeRef.close();
                    }
                    return n;
                }
            };
            int bodyId = body.createJoltBody(factory);
            if (bodyId == -1) {
                VxMainClass.LOGGER.error("Jolt failed to create/add rigid body for {}", (Object)body.getPhysicsId());
                manager.removeBody(body.getPhysicsId(), VxRemovalReason.DISCARD);
                return;
            }
            body.setBodyId(bodyId);
            manager.registerJoltBodyId(bodyId, body);
            body.onBodyAdded(world);
            world.getConstraintManager().getDataSystem().onDependencyLoaded(body.getPhysicsId());
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Failed to create/add rigid body {}", (Object)body.getPhysicsId(), (Object)e);
            manager.removeBody(body.getPhysicsId(), VxRemovalReason.DISCARD);
        }
    }

    public void createAndAddJoltSoftBody(VxSoftBody body, VxBodyManager manager, EActivation activation) {
        try {
            VxPhysicsWorld world = manager.getPhysicsWorld();
            VxBodyDataStore dataStore = manager.getDataStore();
            VxSoftBodyFactory factory = (sharedSettings, creationSettings) -> {
                try (SoftBodySharedSettings softBodySharedSettings = sharedSettings;){
                    int n;
                    block12: {
                        SoftBodyCreationSettings softBodyCreationSettings = creationSettings;
                        try {
                            int index = body.getDataStoreIndex();
                            creationSettings.setPosition(dataStore.posX[index], dataStore.posY[index], dataStore.posZ[index]);
                            creationSettings.setRotation(new Quat(dataStore.rotX[index], dataStore.rotY[index], dataStore.rotZ[index], dataStore.rotW[index]));
                            n = world.getPhysicsSystem().getBodyInterface().createAndAddSoftBody(creationSettings, activation);
                            if (softBodyCreationSettings == null) break block12;
                        }
                        catch (Throwable throwable) {
                            if (softBodyCreationSettings != null) {
                                try {
                                    softBodyCreationSettings.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        softBodyCreationSettings.close();
                    }
                    return n;
                }
            };
            int bodyId = body.createJoltBody(factory);
            if (bodyId == -1) {
                VxMainClass.LOGGER.error("Jolt failed to create/add soft body for {}", (Object)body.getPhysicsId());
                manager.removeBody(body.getPhysicsId(), VxRemovalReason.DISCARD);
                return;
            }
            body.setBodyId(bodyId);
            manager.registerJoltBodyId(bodyId, body);
            body.onBodyAdded(world);
            world.getConstraintManager().getDataSystem().onDependencyLoaded(body.getPhysicsId());
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Failed to create/add soft body {}", (Object)body.getPhysicsId(), (Object)e);
            manager.removeBody(body.getPhysicsId(), VxRemovalReason.DISCARD);
        }
    }

    public void destroyJoltBody(VxPhysicsWorld world, int bodyId) {
        if (bodyId != 0 && bodyId != -1) {
            world.execute(() -> {
                BodyInterface bodyInterface = world.getPhysicsSystem().getBodyInterface();
                if (bodyInterface.isAdded(bodyId)) {
                    bodyInterface.removeBody(bodyId);
                }
                bodyInterface.destroyBody(bodyId);
            });
        }
    }
}

