/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.manager.chunk;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1923;
import net.xmx.velthoric.physics.body.manager.VxBodyDataStore;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.body.manager.VxNetworkDispatcher;
import net.xmx.velthoric.physics.body.type.VxBody;

public class VxChunkManager {
    private final VxBodyManager bodyManager;
    private final VxBodyDataStore dataStore;
    private final VxNetworkDispatcher networkDispatcher;
    private final Long2ObjectMap<List<VxBody>> bodiesByChunk = new Long2ObjectOpenHashMap();

    public VxChunkManager(VxBodyManager bodyManager) {
        this.bodyManager = bodyManager;
        this.dataStore = bodyManager.getDataStore();
        this.networkDispatcher = bodyManager.getNetworkDispatcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTracking(VxBody body) {
        long key;
        int index = body.getDataStoreIndex();
        if (index == -1) {
            return;
        }
        this.dataStore.chunkKey[index] = key = this.bodyManager.getBodyChunkPos(index).method_8324();
        Long2ObjectMap<List<VxBody>> long2ObjectMap = this.bodiesByChunk;
        synchronized (long2ObjectMap) {
            ((List)this.bodiesByChunk.computeIfAbsent(key, k -> new CopyOnWriteArrayList())).add(body);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTracking(VxBody body) {
        int index = body.getDataStoreIndex();
        if (index == -1) {
            return;
        }
        long key = this.dataStore.chunkKey[index];
        if (key != Long.MAX_VALUE) {
            Long2ObjectMap<List<VxBody>> long2ObjectMap = this.bodiesByChunk;
            synchronized (long2ObjectMap) {
                List list = (List)this.bodiesByChunk.get(key);
                if (list != null) {
                    list.remove(body);
                    if (list.isEmpty()) {
                        this.bodiesByChunk.remove(key);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBodyTracking(VxBody body, long fromKey, long toKey) {
        Long2ObjectMap<List<VxBody>> long2ObjectMap;
        int index = body.getDataStoreIndex();
        if (index != -1) {
            this.dataStore.chunkKey[index] = toKey;
        }
        if (fromKey != Long.MAX_VALUE) {
            long2ObjectMap = this.bodiesByChunk;
            synchronized (long2ObjectMap) {
                List fromList = (List)this.bodiesByChunk.get(fromKey);
                if (fromList != null) {
                    fromList.remove(body);
                    if (fromList.isEmpty()) {
                        this.bodiesByChunk.remove(fromKey);
                    }
                }
            }
        }
        long2ObjectMap = this.bodiesByChunk;
        synchronized (long2ObjectMap) {
            ((List)this.bodiesByChunk.computeIfAbsent(toKey, k -> new CopyOnWriteArrayList())).add(body);
        }
        this.networkDispatcher.onBodyMoved(body, new class_1923(fromKey), new class_1923(toKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VxBody> getBodiesInChunk(class_1923 pos) {
        Long2ObjectMap<List<VxBody>> long2ObjectMap = this.bodiesByChunk;
        synchronized (long2ObjectMap) {
            return (List)this.bodiesByChunk.getOrDefault(pos.method_8324(), Collections.emptyList());
        }
    }
}

