/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.buoyancy;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.BodyLockMultiWrite;
import com.github.stephengold.joltjni.MotionProperties;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstAaBox;
import net.xmx.velthoric.physics.buoyancy.VxBuoyancyDataStore;
import net.xmx.velthoric.physics.buoyancy.VxFluidType;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class VxBuoyancyNarrowPhase {
    private final VxPhysicsWorld physicsWorld;
    private final ThreadLocal<Vec3> tempVec3_1 = ThreadLocal.withInitial(Vec3::new);
    private final ThreadLocal<Vec3> tempVec3_2 = ThreadLocal.withInitial(Vec3::new);
    private final ThreadLocal<Vec3> tempVec3_3 = ThreadLocal.withInitial(Vec3::new);
    private final ThreadLocal<RVec3> tempRVec3_1 = ThreadLocal.withInitial(RVec3::new);

    public VxBuoyancyNarrowPhase(VxPhysicsWorld physicsWorld) {
        this.physicsWorld = physicsWorld;
    }

    public void applyForces(BodyLockMultiWrite lock, float deltaTime, VxBuoyancyDataStore dataStore) {
        for (int i = 0; i < dataStore.getCount(); ++i) {
            Body body = lock.getBody(i);
            if (body == null) continue;
            this.processBuoyancyForBody(body, deltaTime, i, dataStore);
        }
    }

    private void processBuoyancyForBody(Body body, float deltaTime, int index, VxBuoyancyDataStore dataStore) {
        Vec3 angularVelocity;
        float angularSpeedSq;
        float verticalVelocity;
        float angularDragCoefficient;
        float linearDragCoefficient;
        float buoyancyMultiplier;
        MotionProperties motionProperties;
        if (!body.isActive()) {
            this.physicsWorld.getPhysicsSystem().getBodyInterface().activateBody(body.getId());
        }
        if ((motionProperties = body.getMotionProperties()) == null || motionProperties.getInverseMass() < 1.0E-6f) {
            return;
        }
        float surfaceY = dataStore.surfaceHeights[index];
        VxFluidType fluidType = dataStore.fluidTypes[index];
        float verticalDampingCoefficient = switch (fluidType) {
            case VxFluidType.LAVA -> {
                buoyancyMultiplier = 2.5f;
                linearDragCoefficient = 10.0f;
                angularDragCoefficient = 5.0f;
                yield 8.0f;
            }
            default -> {
                buoyancyMultiplier = 1.72f;
                linearDragCoefficient = 3.0f;
                angularDragCoefficient = 2.0f;
                yield 5.0f;
            }
        };
        ConstAaBox worldBounds = body.getWorldSpaceBounds();
        float minY = worldBounds.getMin().getY();
        float maxY = worldBounds.getMax().getY();
        float height = maxY - minY;
        if (height < 1.0E-6f) {
            return;
        }
        float submergedDepth = surfaceY - minY;
        float submergedFraction = Math.max(0.0f, Math.min(1.0f, submergedDepth / height));
        if (submergedFraction <= 0.0f) {
            return;
        }
        RVec3 comPosition = body.getCenterOfMassPosition();
        RVec3 centerOfBuoyancyWorld = this.tempRVec3_1.get();
        centerOfBuoyancyWorld.set(comPosition.xx(), minY + submergedDepth * 0.5f, comPosition.zz());
        Vec3 gravity = this.physicsWorld.getPhysicsSystem().getGravity();
        float bodyMass = 1.0f / motionProperties.getInverseMass();
        Vec3 buoyancyImpulse = this.tempVec3_2.get();
        buoyancyImpulse.set(gravity);
        buoyancyImpulse.scaleInPlace(-buoyancyMultiplier * bodyMass * submergedFraction * deltaTime);
        body.addImpulse(buoyancyImpulse, centerOfBuoyancyWorld);
        Vec3 linearVelocity = body.getLinearVelocity();
        float linearSpeedSq = linearVelocity.lengthSq();
        if (linearSpeedSq > 1.0E-6f) {
            Vec3 linearDragImpulse = this.tempVec3_3.get();
            linearDragImpulse.set(linearVelocity);
            linearDragImpulse.scaleInPlace(-linearDragCoefficient * (float)Math.sqrt(linearSpeedSq) * submergedFraction * deltaTime);
            body.addImpulse(linearDragImpulse, centerOfBuoyancyWorld);
        }
        if (Math.abs(verticalVelocity = linearVelocity.getY()) > 1.0E-6f) {
            float verticalDampingImpulse = -verticalVelocity * bodyMass * verticalDampingCoefficient * submergedFraction * deltaTime;
            body.addImpulse(new Vec3(0.0f, verticalDampingImpulse, 0.0f));
        }
        if ((angularSpeedSq = (angularVelocity = body.getAngularVelocity()).lengthSq()) > 1.0E-6f) {
            Vec3 angularDragImpulse = this.tempVec3_1.get();
            angularDragImpulse.set(angularVelocity);
            angularDragImpulse.scaleInPlace(-angularDragCoefficient * (float)Math.sqrt(angularSpeedSq) * submergedFraction * deltaTime);
            body.addAngularImpulse(angularDragImpulse);
        }
    }
}

