/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.constraint.persistence;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import net.minecraft.class_1923;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.constraint.VxConstraint;
import net.xmx.velthoric.physics.constraint.manager.VxConstraintManager;
import net.xmx.velthoric.physics.constraint.persistence.VxConstraintCodec;
import net.xmx.velthoric.physics.persistence.VxAbstractRegionStorage;
import net.xmx.velthoric.physics.persistence.VxRegionIndex;

public class VxConstraintStorage
extends VxAbstractRegionStorage<UUID, byte[]> {
    private final VxConstraintManager constraintManager;
    private final ConcurrentMap<Long, List<UUID>> chunkToUuidIndex = new ConcurrentHashMap<Long, List<UUID>>();

    public VxConstraintStorage(class_3218 level, VxConstraintManager constraintManager) {
        super(level, "constraint", "constraint");
        this.constraintManager = constraintManager;
    }

    @Override
    protected VxRegionIndex createRegionIndex() {
        return new VxRegionIndex(this.storagePath, "constraint");
    }

    @Override
    protected void readRegionData(ByteBuf buffer, VxAbstractRegionStorage.RegionData<UUID, byte[]> regionData) {
        class_2540 friendlyBuf = new class_2540(buffer);
        while (friendlyBuf.isReadable()) {
            UUID id = friendlyBuf.method_10790();
            byte[] data = friendlyBuf.method_10795();
            regionData.entries.put(id, data);
            this.indexConstraintData(id, data);
        }
    }

    @Override
    protected void writeRegionData(ByteBuf buffer, Map<UUID, byte[]> entries) {
        class_2540 friendlyBuf = new class_2540(buffer);
        for (Map.Entry<UUID, byte[]> entry : entries.entrySet()) {
            friendlyBuf.method_10797(entry.getKey());
            friendlyBuf.method_10813(entry.getValue());
        }
    }

    public void storeConstraints(Collection<VxConstraint> constraints) {
        if (constraints == null || constraints.isEmpty()) {
            return;
        }
        HashMap<VxAbstractRegionStorage.RegionPos, List> constraintsByRegion = new HashMap<VxAbstractRegionStorage.RegionPos, List>();
        for (VxConstraint constraint : constraints) {
            int index;
            VxBody body1;
            if (constraint == null || (body1 = this.constraintManager.getBodyManager().getVxBody(constraint.getBody1Id())) == null || (index = body1.getDataStoreIndex()) == -1) continue;
            class_1923 chunkPos = this.constraintManager.getBodyManager().getBodyChunkPos(index);
            VxAbstractRegionStorage.RegionPos regionPos2 = new VxAbstractRegionStorage.RegionPos(chunkPos.field_9181 >> 5, chunkPos.field_9180 >> 5);
            constraintsByRegion.computeIfAbsent(regionPos2, k -> new ArrayList()).add(constraint);
        }
        constraintsByRegion.forEach((regionPos, regionConstraints) -> ((CompletableFuture)this.getRegion((VxAbstractRegionStorage.RegionPos)regionPos).thenAcceptAsync(region -> {
            for (VxConstraint constraint : regionConstraints) {
                VxBody body1 = this.constraintManager.getBodyManager().getVxBody(constraint.getBody1Id());
                if (body1 == null || body1.getDataStoreIndex() == -1) continue;
                class_1923 chunkPos = this.constraintManager.getBodyManager().getBodyChunkPos(body1.getDataStoreIndex());
                byte[] data = this.serializeConstraintData(constraint, chunkPos);
                region.entries.put(constraint.getConstraintId(), data);
                this.regionIndex.put(constraint.getConstraintId(), (VxAbstractRegionStorage.RegionPos)regionPos);
                this.indexConstraintData(constraint.getConstraintId(), data);
            }
            region.dirty.set(true);
        }, (Executor)this.ioExecutor)).exceptionally(ex -> {
            VxMainClass.LOGGER.error("Failed to store constraint batch in region {}", regionPos, ex);
            return null;
        }));
    }

    public void storeConstraint(VxConstraint constraint) {
        if (constraint == null) {
            return;
        }
        this.storeConstraints(Collections.singletonList(constraint));
    }

    public void loadConstraintsInChunk(class_1923 chunkPos) {
        VxAbstractRegionStorage.RegionPos regionPos = new VxAbstractRegionStorage.RegionPos(chunkPos.field_9181 >> 5, chunkPos.field_9180 >> 5);
        ((CompletableFuture)this.getRegion(regionPos).thenRunAsync(() -> {
            List idsToLoad = (List)this.chunkToUuidIndex.get(chunkPos.method_8324());
            if (idsToLoad == null || idsToLoad.isEmpty()) {
                return;
            }
            for (UUID id : List.copyOf(idsToLoad)) {
                if (this.constraintManager.hasActiveConstraint(id) || this.constraintManager.getDataSystem().isPending(id)) continue;
                this.loadConstraint(id);
            }
        }, this.ioExecutor)).exceptionally(ex -> {
            VxMainClass.LOGGER.error("Failed to load constraints in chunk {}", (Object)chunkPos, ex);
            return null;
        });
    }

    public void loadConstraint(UUID id) {
        VxAbstractRegionStorage.RegionPos regionPos = this.regionIndex.get(id);
        if (regionPos == null) {
            return;
        }
        ((CompletableFuture)((CompletableFuture)this.getRegion(regionPos).thenApplyAsync(region -> {
            byte[] data = (byte[])region.entries.get(id);
            if (data != null) {
                return this.deserializeConstraint(id, data);
            }
            return null;
        }, (Executor)this.ioExecutor)).thenAcceptAsync(constraint -> {
            if (constraint != null) {
                this.constraintManager.addConstraintFromStorage((VxConstraint)constraint);
            }
        }, (Executor)this.level.method_8503())).exceptionally(ex -> {
            VxMainClass.LOGGER.error("Exception loading physics constraint {}", (Object)id, ex);
            return null;
        });
    }

    public void removeData(UUID id) {
        VxAbstractRegionStorage.RegionPos regionPos = this.regionIndex.get(id);
        if (regionPos == null) {
            return;
        }
        ((CompletableFuture)this.getRegion(regionPos).thenAcceptAsync(region -> {
            byte[] data = (byte[])region.entries.remove(id);
            if (data != null) {
                region.dirty.set(true);
                this.deIndexConstraint(id, data);
                this.regionIndex.remove(id);
            }
        }, (Executor)this.ioExecutor)).exceptionally(ex -> {
            VxMainClass.LOGGER.error("Failed to remove data for constraint {}", (Object)id, ex);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VxConstraint deserializeConstraint(UUID id, byte[] data) {
        class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])data));
        try {
            buf.readLong();
            VxConstraint vxConstraint = VxConstraintCodec.deserialize(id, buf);
            return vxConstraint;
        }
        finally {
            if (buf.refCnt() > 0) {
                buf.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serializeConstraintData(VxConstraint constraint, class_1923 pos) {
        ByteBuf buffer = Unpooled.buffer();
        class_2540 buf = new class_2540(buffer);
        try {
            buf.writeLong(pos.method_8324());
            VxConstraintCodec.serialize(constraint, buf);
            byte[] data = new byte[buffer.readableBytes()];
            buffer.readBytes(data);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            if (buffer.refCnt() > 0) {
                buffer.release();
            }
        }
    }

    private void indexConstraintData(UUID id, byte[] data) {
        long chunkKey = this.getChunkKeyFromData(data);
        this.chunkToUuidIndex.computeIfAbsent(chunkKey, k -> new CopyOnWriteArrayList()).add(id);
    }

    private void deIndexConstraint(UUID id, byte[] data) {
        long chunkKey = this.getChunkKeyFromData(data);
        List idList = (List)this.chunkToUuidIndex.get(chunkKey);
        if (idList != null) {
            idList.remove(id);
            if (idList.isEmpty()) {
                this.chunkToUuidIndex.remove(chunkKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getChunkKeyFromData(byte[] data) {
        class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])data));
        try {
            long l = buf.readLong();
            return l;
        }
        finally {
            if (buf.refCnt() > 0) {
                buf.release();
            }
        }
    }
}

