/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.raycasting;

import com.github.stephengold.joltjni.BodyLockRead;
import com.github.stephengold.joltjni.ClosestHitCastRayCollector;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.RRayCast;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.RayCastResult;
import com.github.stephengold.joltjni.RayCastSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.ConstNarrowPhaseQuery;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5321;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.physics.raycasting.VxClipContext;
import net.xmx.velthoric.physics.raycasting.VxHitResult;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class VxRaytracing {
    private VxRaytracing() {
    }

    public static Optional<VxHitResult> raycast(class_1937 level, VxClipContext context) {
        class_243 from = context.method_17750();
        class_243 to = context.method_17747();
        ArrayList hits = new ArrayList();
        VxRaytracing.raycastMinecraftInternal(level, context).ifPresent(hits::add);
        if (context.isIncludePhysics()) {
            double maxDistance = from.method_1022(to);
            class_243 direction = to.method_1020(from).method_1029();
            RVec3 rayOrigin = new RVec3((float)from.field_1352, (float)from.field_1351, (float)from.field_1350);
            Vec3 rayDirection = new Vec3((float)direction.field_1352, (float)direction.field_1351, (float)direction.field_1350);
            VxRaytracing.raycastPhysicsInternal(level, rayOrigin, rayDirection, (float)maxDistance).ifPresent(hits::add);
        }
        return hits.stream().min(Comparator.comparingDouble(hit -> hit.method_17784().method_1025(from)));
    }

    public static Optional<VxHitResult> raycastMinecraft(class_1937 level, VxClipContext context) {
        return VxRaytracing.raycastMinecraftInternal(level, context);
    }

    public static Optional<VxHitResult> raycastPhysics(class_1937 level, RVec3 rayOrigin, Vec3 rayDirection, float maxDistance) {
        return VxRaytracing.raycastPhysicsInternal(level, rayOrigin, rayDirection, maxDistance);
    }

    private static Optional<VxHitResult> raycastMinecraftInternal(class_1937 level, VxClipContext context) {
        double entityHitSq;
        Predicate<class_1297> entityPredicate;
        class_238 searchBox;
        class_3966 entityHitResult;
        class_243 from = context.method_17750();
        class_243 to = context.method_17747();
        class_3965 blockHitResult = level.method_17742((class_3959)context);
        double closestHitSq = blockHitResult.method_17783() == class_239.class_240.field_1333 ? Double.MAX_VALUE : blockHitResult.method_17784().method_1025(from);
        class_3965 finalHit = blockHitResult;
        class_1297 entity = context.getEntity();
        if (entity != null && (entityHitResult = class_1675.method_18077((class_1937)level, (class_1297)entity, (class_243)from, (class_243)to, (class_238)(searchBox = new class_238(from, to)), entityPredicate = e -> !e.method_7325() && e.method_5863())) != null && (entityHitSq = entityHitResult.method_17784().method_1025(from)) < closestHitSq) {
            finalHit = entityHitResult;
        }
        return finalHit.method_17783() != class_239.class_240.field_1333 ? Optional.of(new VxHitResult((class_239)finalHit)) : Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<VxHitResult> raycastPhysicsInternal(class_1937 level, RVec3 rayOrigin, Vec3 rayDirection, float maxDistance) {
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((class_5321<class_1937>)level.method_27983());
        if (physicsWorld == null) return Optional.empty();
        if (!physicsWorld.isRunning()) return Optional.empty();
        if (physicsWorld.getPhysicsSystem() == null) {
            return Optional.empty();
        }
        PhysicsSystem physicsSystem = physicsWorld.getPhysicsSystem();
        ConstNarrowPhaseQuery narrowPhaseQuery = physicsSystem.getNarrowPhaseQuery();
        Vec3 directionAndLength = Op.star((Vec3Arg)rayDirection, maxDistance);
        try (RRayCast ray = new RRayCast(rayOrigin, directionAndLength);
             RayCastSettings settings = new RayCastSettings();
             ClosestHitCastRayCollector collector = new ClosestHitCastRayCollector();){
            narrowPhaseQuery.castRay(ray, settings, collector);
            if (!collector.hadHit()) return Optional.empty();
            RayCastResult hit = collector.getHit();
            float hitFraction = hit.getFraction();
            RVec3 hitPointR = ray.getPointOnRay(hitFraction);
            class_243 hitPoint = new class_243(hitPointR.xx(), hitPointR.yy(), hitPointR.zz());
            int bodyId = hit.getBodyId();
            try (BodyLockRead lock = new BodyLockRead(physicsSystem.getBodyLockInterface(), bodyId);){
                if (!lock.succeededAndIsInBroadPhase()) return Optional.empty();
                Vec3 hitNormal = lock.getBody().getWorldSpaceSurfaceNormal(hit.getSubShapeId2(), hitPointR);
                Optional<VxHitResult> optional = Optional.of(new VxHitResult(hitPoint, bodyId, new Vec3(hitNormal), hitFraction));
                return optional;
            }
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Exception during physics raycast", (Throwable)e);
        }
        return Optional.empty();
    }

    private static class_243 transformToLocal(class_243 worldVec, Vector3f pos, Quaternionf invRot) {
        Vector3f tempVec = new Vector3f((float)worldVec.field_1352, (float)worldVec.field_1351, (float)worldVec.field_1350);
        tempVec.sub((Vector3fc)pos);
        invRot.transform(tempVec);
        return new class_243((double)tempVec.x, (double)tempVec.y, (double)tempVec.z);
    }

    private static Vec3 calculateHitNormal(class_243 localHit, class_238 localAABB, Quaternionf worldRot) {
        float epsilon = 1.0E-5f;
        Vector3f localNormal = new Vector3f();
        if (Math.abs(localHit.field_1352 - localAABB.field_1323) < (double)1.0E-5f) {
            localNormal.x = -1.0f;
        } else if (Math.abs(localHit.field_1352 - localAABB.field_1320) < (double)1.0E-5f) {
            localNormal.x = 1.0f;
        } else if (Math.abs(localHit.field_1351 - localAABB.field_1322) < (double)1.0E-5f) {
            localNormal.y = -1.0f;
        } else if (Math.abs(localHit.field_1351 - localAABB.field_1325) < (double)1.0E-5f) {
            localNormal.y = 1.0f;
        } else if (Math.abs(localHit.field_1350 - localAABB.field_1321) < (double)1.0E-5f) {
            localNormal.z = -1.0f;
        } else if (Math.abs(localHit.field_1350 - localAABB.field_1324) < (double)1.0E-5f) {
            localNormal.z = 1.0f;
        }
        worldRot.transform(localNormal);
        return new Vec3(localNormal.x, localNormal.y, localNormal.z);
    }
}

