/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.terrain;

import com.github.stephengold.joltjni.RVec3;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_4076;

public final class VxSectionPos {
    public static final int CHUNK_SIZE = 16;
    public static final int CHUNK_SIZE_SHIFT = 4;
    private final int x;
    private final int y;
    private final int z;

    public VxSectionPos() {
        this(0, 0, 0);
    }

    public VxSectionPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int z() {
        return this.z;
    }

    public class_1923 toChunkPos2D() {
        return new class_1923(this.x, this.z);
    }

    public static VxSectionPos fromBlockPos(class_2338 pos) {
        return new VxSectionPos(pos.method_10263() >> 4, pos.method_10264() >> 4, pos.method_10260() >> 4);
    }

    public static VxSectionPos fromRVec3(RVec3 pos) {
        return new VxSectionPos(class_4076.method_42615((double)pos.x()), class_4076.method_42615((double)pos.y()), class_4076.method_42615((double)pos.z()));
    }

    public static VxSectionPos fromWorldSpace(double x, double y, double z) {
        return new VxSectionPos((int)Math.floor(x) >> 4, (int)Math.floor(y) >> 4, (int)Math.floor(z) >> 4);
    }

    public class_2338 getOrigin() {
        return new class_2338(this.x << 4, this.y << 4, this.z << 4);
    }

    public class_238 getAABB() {
        class_2338 origin = this.getOrigin();
        return new class_238(origin, origin.method_10069(16, 16, 16));
    }

    public boolean isWithinWorldHeight(class_1937 level) {
        int minBlockY = this.y << 4;
        int maxBlockY = minBlockY + 15;
        return maxBlockY >= level.method_31607() && minBlockY < level.method_31600();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VxSectionPos)) {
            return false;
        }
        VxSectionPos other = (VxSectionPos)o;
        return this.x == other.x && this.y == other.y && this.z == other.z;
    }

    public int hashCode() {
        return (this.x * 31 + this.y) * 31 + this.z;
    }

    public String toString() {
        return "VxSectionPos[" + this.x + ", " + this.y + ", " + this.z + "]";
    }
}

